/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal;

import com.obs.services.internal.DefaultProgressStatus;
import com.obs.services.internal.ProgressManager;
import com.obs.services.model.ProgressListener;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class ConcurrentProgressManager
extends ProgressManager {
    private AtomicBoolean startFlag = new AtomicBoolean(false);
    protected AtomicLong transferredBytes;
    protected AtomicLong newlyTransferredBytes;
    protected AtomicLong lastSecondBytes;
    protected AtomicLong currentSecondBytes;
    protected AtomicLong lastSwapTimeStamp;

    public ConcurrentProgressManager(long totalBytes, long transferredBytes, ProgressListener progressListener, long intervalBytes) {
        super(totalBytes, progressListener, intervalBytes);
        this.transferredBytes = transferredBytes < 0L ? new AtomicLong(0L) : new AtomicLong(transferredBytes);
        this.newlyTransferredBytes = new AtomicLong(0L);
        this.lastSecondBytes = new AtomicLong(-1L);
        this.currentSecondBytes = new AtomicLong(0L);
        this.lastSwapTimeStamp = new AtomicLong(System.currentTimeMillis());
    }

    @Override
    public void progressStart() {
        if (this.startFlag.compareAndSet(false, true)) {
            super.progressStart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void progressEnd() {
        if (this.progressListener == null) {
            return;
        }
        ConcurrentProgressManager concurrentProgressManager = this;
        synchronized (concurrentProgressManager) {
            long now = System.currentTimeMillis();
            DefaultProgressStatus status = new DefaultProgressStatus(this.newlyTransferredBytes.get(), this.transferredBytes.get(), this.totalBytes, now - this.lastCheckpoint, now - this.startCheckpoint);
            this.progressListener.progressChanged(status);
        }
    }

    @Override
    protected void doProgressChanged(int bytes) {
        long transferred = this.transferredBytes.addAndGet(bytes);
        long newlyTransferred = this.newlyTransferredBytes.addAndGet(bytes);
        long now = System.currentTimeMillis();
        long swapIntervalTime = now - this.lastSwapTimeStamp.get();
        this.currentSecondBytes.addAndGet(bytes);
        if (swapIntervalTime > 1000L) {
            this.lastSecondBytes.set((long)((double)this.currentSecondBytes.get() / ((double)swapIntervalTime / 1000.0)));
            this.currentSecondBytes.set(0L);
            this.lastSwapTimeStamp.set(now);
        }
        if (newlyTransferred >= this.intervalBytes && (transferred < this.totalBytes || this.totalBytes == -1L) && this.newlyTransferredBytes.compareAndSet(newlyTransferred, -newlyTransferred)) {
            DefaultProgressStatus status = new DefaultProgressStatus(newlyTransferred, transferred, this.totalBytes, now - this.lastCheckpoint, now - this.startCheckpoint);
            status.setInstantaneousSpeed(this.lastSecondBytes.get());
            this.progressListener.progressChanged(status);
            this.lastCheckpoint = now;
        }
    }
}

