/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.validator.resource;

import java.io.Serializable;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.validator.ITransformer;
import org.apache.dolphinscheduler.dao.entity.Tenant;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.repository.TenantDao;
import org.apache.dolphinscheduler.plugin.storage.api.StorageOperator;
import org.apache.dolphinscheduler.spi.enums.ResourceType;

public abstract class AbstractResourceTransformer<T, R>
implements ITransformer<T, R> {
    protected TenantDao tenantDao;
    protected StorageOperator storageOperator;

    protected String getParentDirectoryAbsolutePath(User loginUser, String parentAbsoluteDirectory, ResourceType type) {
        String tenantCode = ((Tenant)this.tenantDao.queryOptionalById((Serializable)Integer.valueOf(loginUser.getTenantId())).orElseThrow(() -> new ServiceException(Status.CURRENT_LOGIN_USER_TENANT_NOT_EXIST))).getTenantCode();
        String userResRootPath = this.storageOperator.getStorageBaseDirectory(tenantCode, type);
        if (parentAbsoluteDirectory.equals("/")) {
            return userResRootPath;
        }
        if (!StringUtils.startsWith((CharSequence)parentAbsoluteDirectory, (CharSequence)userResRootPath)) {
            throw new ServiceException(Status.ILLEGAL_RESOURCE_PATH, parentAbsoluteDirectory);
        }
        return parentAbsoluteDirectory;
    }

    @Generated
    public AbstractResourceTransformer(TenantDao tenantDao, StorageOperator storageOperator) {
        this.tenantDao = tenantDao;
        this.storageOperator = storageOperator;
    }
}

