/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.dto.DagDataSchedule;
import org.apache.dolphinscheduler.api.dto.TaskCodeVersionDto;
import org.apache.dolphinscheduler.api.dto.treeview.Instance;
import org.apache.dolphinscheduler.api.dto.treeview.TreeViewDto;
import org.apache.dolphinscheduler.api.dto.workflow.WorkflowCreateRequest;
import org.apache.dolphinscheduler.api.dto.workflow.WorkflowFilterRequest;
import org.apache.dolphinscheduler.api.dto.workflow.WorkflowUpdateRequest;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.service.MetricsCleanUpService;
import org.apache.dolphinscheduler.api.service.ProjectService;
import org.apache.dolphinscheduler.api.service.SchedulerService;
import org.apache.dolphinscheduler.api.service.TaskDefinitionLogService;
import org.apache.dolphinscheduler.api.service.TaskDefinitionService;
import org.apache.dolphinscheduler.api.service.WorkflowDefinitionService;
import org.apache.dolphinscheduler.api.service.WorkflowInstanceService;
import org.apache.dolphinscheduler.api.service.WorkflowLineageService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.CheckUtils;
import org.apache.dolphinscheduler.api.utils.FileUtils;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.ConditionType;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.Priority;
import org.apache.dolphinscheduler.common.enums.ReleaseState;
import org.apache.dolphinscheduler.common.enums.TimeoutFlag;
import org.apache.dolphinscheduler.common.enums.UserType;
import org.apache.dolphinscheduler.common.enums.WorkflowExecutionStatus;
import org.apache.dolphinscheduler.common.enums.WorkflowExecutionTypeEnum;
import org.apache.dolphinscheduler.common.graph.DAG;
import org.apache.dolphinscheduler.common.lifecycle.ServerLifeCycleManager;
import org.apache.dolphinscheduler.common.utils.CodeGenerateUtils;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.DagData;
import org.apache.dolphinscheduler.dao.entity.DataSource;
import org.apache.dolphinscheduler.dao.entity.DependentSimplifyDefinition;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.Schedule;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.TaskDefinitionLog;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.entity.WorkflowDefinition;
import org.apache.dolphinscheduler.dao.entity.WorkflowDefinitionLog;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstance;
import org.apache.dolphinscheduler.dao.entity.WorkflowTaskLineage;
import org.apache.dolphinscheduler.dao.entity.WorkflowTaskRelation;
import org.apache.dolphinscheduler.dao.entity.WorkflowTaskRelationLog;
import org.apache.dolphinscheduler.dao.mapper.DataSourceMapper;
import org.apache.dolphinscheduler.dao.mapper.ProjectMapper;
import org.apache.dolphinscheduler.dao.mapper.ScheduleMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskDefinitionLogMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskInstanceMapper;
import org.apache.dolphinscheduler.dao.mapper.UserMapper;
import org.apache.dolphinscheduler.dao.mapper.WorkflowDefinitionLogMapper;
import org.apache.dolphinscheduler.dao.mapper.WorkflowDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.WorkflowTaskRelationLogMapper;
import org.apache.dolphinscheduler.dao.mapper.WorkflowTaskRelationMapper;
import org.apache.dolphinscheduler.dao.model.PageListingResult;
import org.apache.dolphinscheduler.dao.repository.TaskDefinitionLogDao;
import org.apache.dolphinscheduler.dao.repository.WorkflowDefinitionDao;
import org.apache.dolphinscheduler.dao.repository.WorkflowDefinitionLogDao;
import org.apache.dolphinscheduler.dao.utils.WorkerGroupUtils;
import org.apache.dolphinscheduler.plugin.task.api.TaskPluginManager;
import org.apache.dolphinscheduler.plugin.task.api.enums.SqlType;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskTimeoutStrategy;
import org.apache.dolphinscheduler.plugin.task.api.model.DependentItem;
import org.apache.dolphinscheduler.plugin.task.api.model.DependentTaskModel;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;
import org.apache.dolphinscheduler.plugin.task.api.parameters.DependentParameters;
import org.apache.dolphinscheduler.plugin.task.api.parameters.SqlParameters;
import org.apache.dolphinscheduler.plugin.task.api.parameters.SwitchParameters;
import org.apache.dolphinscheduler.plugin.task.api.utils.TaskTypeUtils;
import org.apache.dolphinscheduler.service.model.TaskNode;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class WorkflowDefinitionServiceImpl
extends BaseServiceImpl
implements WorkflowDefinitionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkflowDefinitionServiceImpl.class);
    private static final String RELEASESTATE = "releaseState";
    @Autowired
    private ProjectMapper projectMapper;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private WorkflowDefinitionLogMapper workflowDefinitionLogMapper;
    @Autowired
    private WorkflowDefinitionMapper workflowDefinitionMapper;
    @Autowired
    private WorkflowDefinitionDao workflowDefinitionDao;
    @Autowired
    private WorkflowDefinitionLogDao workflowDefinitionLogDao;
    @Lazy
    @Autowired
    private WorkflowInstanceService workflowInstanceService;
    @Autowired
    private TaskInstanceMapper taskInstanceMapper;
    @Autowired
    private ScheduleMapper scheduleMapper;
    @Autowired
    private ProcessService processService;
    @Autowired
    private TaskDefinitionLogDao taskDefinitionLogDao;
    @Autowired
    private WorkflowTaskRelationMapper workflowTaskRelationMapper;
    @Autowired
    private WorkflowTaskRelationLogMapper workflowTaskRelationLogMapper;
    @Autowired
    TaskDefinitionLogMapper taskDefinitionLogMapper;
    @Lazy
    @Autowired
    private TaskDefinitionService taskDefinitionService;
    @Autowired
    private TaskDefinitionLogService taskDefinitionLogService;
    @Autowired
    private TaskDefinitionMapper taskDefinitionMapper;
    @Lazy
    @Autowired
    private SchedulerService schedulerService;
    @Autowired
    private DataSourceMapper dataSourceMapper;
    @Autowired
    private WorkflowLineageService workflowLineageService;
    @Autowired
    private MetricsCleanUpService metricsCleanUpService;

    @Override
    @Transactional
    public Map<String, Object> createWorkflowDefinition(User loginUser, long projectCode, String name, String description, String globalParams, String locations, int timeout, String taskRelationJson, String taskDefinitionJson, String otherParamsJson, WorkflowExecutionTypeEnum executionType) {
        Map<String, Object> result;
        Project project = this.projectMapper.queryByCode(projectCode);
        boolean hasProjectAndWritePerm = this.projectService.hasProjectAndWritePerm(loginUser, project, result = new HashMap<String, Object>());
        if (!hasProjectAndWritePerm) {
            return result;
        }
        if (this.checkDescriptionLength(description)) {
            log.warn("Parameter description is too long.");
            throw new ServiceException(Status.DESCRIPTION_TOO_LONG_ERROR);
        }
        WorkflowDefinition definition = this.workflowDefinitionMapper.verifyByDefineName(project.getCode(), name);
        if (definition != null) {
            log.warn("workflow definition with the same name {} already exists, workflowDefinitionCode:{}.", (Object)definition.getName(), (Object)definition.getCode());
            throw new ServiceException(Status.WORKFLOW_DEFINITION_NAME_EXIST, name);
        }
        List<TaskDefinitionLog> taskDefinitionLogs = this.generateTaskDefinitionList(taskDefinitionJson);
        List<WorkflowTaskRelationLog> taskRelationList = this.generateTaskRelationList(taskRelationJson, taskDefinitionLogs);
        long workflowDefinitionCode = CodeGenerateUtils.genCode();
        WorkflowDefinition workflowDefinition = new WorkflowDefinition(projectCode, name, workflowDefinitionCode, description, globalParams, locations, timeout, loginUser.getId().intValue());
        workflowDefinition.setExecutionType(executionType);
        result = this.createDagDefine(loginUser, taskRelationList, workflowDefinition, taskDefinitionLogs);
        return result;
    }

    private void createWorkflowValid(User user, WorkflowDefinition workflowDefinition) {
        Project project = this.projectMapper.queryByCode(workflowDefinition.getProjectCode());
        if (project == null) {
            throw new ServiceException(Status.PROJECT_NOT_FOUND, workflowDefinition.getProjectCode());
        }
        this.projectService.checkProjectAndAuthThrowException(user, project, "project:definition:create");
        if (this.checkDescriptionLength(workflowDefinition.getDescription())) {
            throw new ServiceException(Status.DESCRIPTION_TOO_LONG_ERROR);
        }
        WorkflowDefinition definition = this.workflowDefinitionMapper.verifyByDefineName(project.getCode(), workflowDefinition.getName());
        if (definition != null) {
            throw new ServiceException(Status.WORKFLOW_DEFINITION_NAME_EXIST, workflowDefinition.getName());
        }
    }

    private void syncObj2Log(User user, WorkflowDefinition workflowDefinition) {
        WorkflowDefinitionLog workflowDefinitionLog = new WorkflowDefinitionLog(workflowDefinition);
        workflowDefinitionLog.setOperator(user.getId().intValue());
        int result = this.workflowDefinitionLogMapper.insert((Object)workflowDefinitionLog);
        if (result <= 0) {
            throw new ServiceException(Status.CREATE_WORKFLOW_DEFINITION_LOG_ERROR);
        }
    }

    @Override
    @Transactional
    public WorkflowDefinition createSingleWorkflowDefinition(User loginUser, WorkflowCreateRequest workflowCreateRequest) {
        WorkflowDefinition workflowDefinition = workflowCreateRequest.convert2WorkflowDefinition();
        this.createWorkflowValid(loginUser, workflowDefinition);
        workflowDefinition.setCode(CodeGenerateUtils.genCode());
        workflowDefinition.setUserId(loginUser.getId().intValue());
        int create = this.workflowDefinitionMapper.insert((Object)workflowDefinition);
        if (create <= 0) {
            throw new ServiceException(Status.CREATE_WORKFLOW_DEFINITION_ERROR);
        }
        this.syncObj2Log(loginUser, workflowDefinition);
        return workflowDefinition;
    }

    protected Map<String, Object> createDagDefine(User loginUser, List<WorkflowTaskRelationLog> taskRelationList, WorkflowDefinition workflowDefinition, List<TaskDefinitionLog> taskDefinitionLogs) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        int saveTaskResult = this.processService.saveTaskDefine(loginUser, workflowDefinition.getProjectCode(), taskDefinitionLogs, Boolean.TRUE);
        if (saveTaskResult == 0) {
            log.info("The task has not changed, so skip");
        }
        if (saveTaskResult == -1) {
            log.error("Save task definition error.");
            throw new ServiceException(Status.CREATE_TASK_DEFINITION_ERROR);
        }
        int insertVersion = this.processService.saveWorkflowDefine(loginUser, workflowDefinition, Boolean.TRUE, Boolean.TRUE);
        if (insertVersion == 0) {
            log.error("Save workflow definition error, workflowDefinitionCode:{}.", (Object)workflowDefinition.getCode());
            throw new ServiceException(Status.CREATE_WORKFLOW_DEFINITION_ERROR);
        }
        log.info("Save workflow definition complete, workflowDefinitionCode:{}, workflowDefinitionVersion:{}.", (Object)workflowDefinition.getCode(), (Object)insertVersion);
        int insertResult = this.processService.saveTaskRelation(loginUser, workflowDefinition.getProjectCode(), workflowDefinition.getCode(), insertVersion, taskRelationList, taskDefinitionLogs, Boolean.TRUE);
        if (insertResult != 0) {
            log.error("Save workflow task relations error, projectCode:{}, workflowDefinitionCode:{}, workflowDefinitionVersion:{}.", new Object[]{workflowDefinition.getProjectCode(), workflowDefinition.getCode(), insertVersion});
            throw new ServiceException(Status.CREATE_WORKFLOW_TASK_RELATION_ERROR);
        }
        log.info("Save workflow task relations complete, projectCode:{}, workflowDefinitionCode:{}, workflowDefinitionVersion:{}.", new Object[]{workflowDefinition.getProjectCode(), workflowDefinition.getCode(), insertVersion});
        this.saveWorkflowLineage(workflowDefinition.getProjectCode(), workflowDefinition.getCode(), insertVersion, taskDefinitionLogs);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        result.put("data", workflowDefinition);
        return result;
    }

    @Override
    public void saveWorkflowLineage(long projectCode, long workflowDefinitionCode, int workflowDefinitionVersion, List<TaskDefinitionLog> taskDefinitionLogList) {
        List<WorkflowTaskLineage> workflowTaskLineageList = this.generateWorkflowLineageList(taskDefinitionLogList, workflowDefinitionCode, workflowDefinitionVersion);
        this.workflowLineageService.updateWorkflowLineage(workflowDefinitionCode, workflowTaskLineageList);
    }

    private List<WorkflowTaskLineage> generateWorkflowLineageList(List<TaskDefinitionLog> taskDefinitionLogList, long workflowDefinitionCode, int workflowDefinitionVersion) {
        ArrayList<WorkflowTaskLineage> workflowTaskLineageList = new ArrayList<WorkflowTaskLineage>();
        for (TaskDefinitionLog taskDefinitionLog : taskDefinitionLogList) {
            if (!TaskTypeUtils.isDependentTask((String)taskDefinitionLog.getTaskType())) continue;
            for (DependentTaskModel dependentTaskModel : ((DependentParameters)JSONUtils.parseObject((String)taskDefinitionLog.getTaskParams(), DependentParameters.class)).getDependence().getDependTaskList()) {
                for (DependentItem dependentItem : dependentTaskModel.getDependItemList()) {
                    WorkflowTaskLineage workflowTaskLineage = new WorkflowTaskLineage();
                    workflowTaskLineage.setWorkflowDefinitionCode(workflowDefinitionCode);
                    workflowTaskLineage.setWorkflowDefinitionVersion(workflowDefinitionVersion);
                    workflowTaskLineage.setTaskDefinitionCode(taskDefinitionLog.getCode());
                    workflowTaskLineage.setTaskDefinitionVersion(taskDefinitionLog.getVersion());
                    workflowTaskLineage.setDeptProjectCode(taskDefinitionLog.getProjectCode());
                    workflowTaskLineage.setDeptWorkflowDefinitionCode(dependentItem.getDefinitionCode());
                    workflowTaskLineage.setDeptTaskDefinitionCode(dependentItem.getDepTaskCode());
                    workflowTaskLineageList.add(workflowTaskLineage);
                }
            }
        }
        return workflowTaskLineageList;
    }

    private List<TaskDefinitionLog> generateTaskDefinitionList(String taskDefinitionJson) {
        try {
            List taskDefinitionLogs = JSONUtils.toList((String)taskDefinitionJson, TaskDefinitionLog.class);
            if (CollectionUtils.isEmpty((Collection)taskDefinitionLogs)) {
                log.error("Generate task definition list failed, the given taskDefinitionJson is invalided: {}", (Object)taskDefinitionJson);
                throw new ServiceException(Status.DATA_IS_NOT_VALID, taskDefinitionJson);
            }
            HashSet<String> taskNameSet = new HashSet<String>();
            for (TaskDefinitionLog taskDefinitionLog : taskDefinitionLogs) {
                if (!taskNameSet.add(taskDefinitionLog.getName())) {
                    log.error("Generate task definition list failed, the given task definition name is duplicate, taskName: {}, taskDefinition: {}", (Object)taskDefinitionLog.getName(), (Object)taskDefinitionLog);
                    throw new ServiceException(Status.TASK_NAME_DUPLICATE_ERROR, taskDefinitionLog.getName());
                }
                if (TaskPluginManager.checkTaskParameters((String)taskDefinitionLog.getTaskType(), (String)taskDefinitionLog.getTaskParams())) continue;
                log.error("Generate task definition list failed, the given task definition parameter is invalided, taskName: {}, taskDefinition: {}", (Object)taskDefinitionLog.getName(), (Object)taskDefinitionLog);
                throw new ServiceException(Status.WORKFLOW_NODE_S_PARAMETER_INVALID, taskDefinitionLog.getName());
            }
            return taskDefinitionLogs;
        }
        catch (ServiceException ex) {
            throw ex;
        }
        catch (Exception e) {
            log.error("Generate task definition list failed, meet an unknown exception", (Throwable)e);
            throw new ServiceException(Status.REQUEST_PARAMS_NOT_VALID_ERROR);
        }
    }

    private List<WorkflowTaskRelationLog> generateTaskRelationList(String taskRelationJson, List<TaskDefinitionLog> taskDefinitionLogs) {
        try {
            Set taskNodeCodes;
            Set postTaskCodes;
            Collection codes;
            List taskRelationList = JSONUtils.toList((String)taskRelationJson, WorkflowTaskRelationLog.class);
            if (CollectionUtils.isEmpty((Collection)taskRelationList)) {
                log.error("Generate task relation list failed the taskRelation list is empty, taskRelationJson: {}", (Object)taskRelationJson);
                throw new ServiceException(Status.DATA_IS_NOT_VALID);
            }
            List workflowTaskRelations = taskRelationList.stream().map(workflowTaskRelationLog -> (WorkflowTaskRelation)JSONUtils.parseObject((String)JSONUtils.toJsonString((Object)workflowTaskRelationLog), WorkflowTaskRelation.class)).collect(Collectors.toList());
            List taskNodeList = this.processService.transformTask(workflowTaskRelations, taskDefinitionLogs);
            if (taskNodeList.size() != taskRelationList.size() && CollectionUtils.isNotEmpty((Collection)(codes = CollectionUtils.subtract(postTaskCodes = taskRelationList.stream().map(WorkflowTaskRelation::getPostTaskCode).collect(Collectors.toSet()), taskNodeCodes = taskNodeList.stream().map(TaskNode::getCode).collect(Collectors.toSet()))))) {
                String taskCodes = StringUtils.join((Iterable)codes, (String)",");
                log.error("Task definitions do not exist, taskCodes:{}.", (Object)taskCodes);
                throw new ServiceException(Status.TASK_DEFINE_NOT_EXIST, taskCodes);
            }
            if (this.graphHasCycle(taskNodeList)) {
                log.error("workflow DAG has cycle.");
                throw new ServiceException(Status.WORKFLOW_NODE_HAS_CYCLE);
            }
            for (WorkflowTaskRelationLog workflowTaskRelationLog2 : taskRelationList) {
                if (workflowTaskRelationLog2.getPostTaskCode() != 0L) continue;
                log.error("The post_task_code or post_task_version of workflowTaskRelationLog can not be zero, workflowTaskRelationLogId:{}.", (Object)workflowTaskRelationLog2.getId());
                throw new ServiceException(Status.CHECK_WORKFLOW_TASK_RELATION_ERROR);
            }
            return taskRelationList;
        }
        catch (ServiceException ex) {
            throw ex;
        }
        catch (Exception e) {
            log.error("Check task relation list error, meet an unknown exception, given taskRelationJson: {}", (Object)taskRelationJson, (Object)e);
            throw new ServiceException(Status.REQUEST_PARAMS_NOT_VALID_ERROR);
        }
    }

    @Override
    public Map<String, Object> queryWorkflowDefinitionList(User loginUser, long projectCode) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, "project:definition:list");
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        List resourceList = this.workflowDefinitionMapper.queryAllDefinitionList(projectCode);
        List dagDataList = resourceList.stream().map(arg_0 -> ((ProcessService)this.processService).genDagData(arg_0)).collect(Collectors.toList());
        result.put("data", dagDataList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> queryWorkflowDefinitionSimpleList(User loginUser, long projectCode) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, "project:definition:list");
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        List workflowDefinitions = this.workflowDefinitionMapper.queryAllDefinitionList(projectCode);
        ArrayNode arrayNode = JSONUtils.createArrayNode();
        for (WorkflowDefinition workflowDefinition : workflowDefinitions) {
            ObjectNode workflowDefinitionNode = JSONUtils.createObjectNode();
            workflowDefinitionNode.put("id", workflowDefinition.getId());
            workflowDefinitionNode.put("code", workflowDefinition.getCode());
            workflowDefinitionNode.put("name", workflowDefinition.getName());
            workflowDefinitionNode.put("projectCode", workflowDefinition.getProjectCode());
            arrayNode.add((JsonNode)workflowDefinitionNode);
        }
        result.put("data", arrayNode);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public PageInfo<WorkflowDefinition> queryWorkflowDefinitionListPaging(@NonNull User loginUser, long projectCode, String searchVal, String otherParamsJson, Integer userId, Integer pageNo, Integer pageSize) {
        if (loginUser == null) {
            throw new NullPointerException("loginUser is marked non-null but is null");
        }
        this.projectService.checkProjectAndAuthThrowException(loginUser, projectCode, "project:definition:list");
        PageListingResult workflowDefinitionPageListingResult = this.workflowDefinitionDao.listingWorkflowDefinition(pageNo.intValue(), pageSize.intValue(), searchVal, userId.intValue(), projectCode);
        List workflowDefinitions = workflowDefinitionPageListingResult.getRecords();
        List<Long> workflowDefinitionCodes = workflowDefinitions.stream().map(WorkflowDefinition::getCode).collect(Collectors.toList());
        Map scheduleMap = this.schedulerService.queryScheduleByWorkflowDefinitionCodes(workflowDefinitionCodes).stream().collect(Collectors.toMap(Schedule::getWorkflowDefinitionCode, Function.identity()));
        List userWithCodes = this.userMapper.queryUserWithWorkflowDefinitionCode(workflowDefinitionCodes);
        for (WorkflowDefinition pd : workflowDefinitions) {
            userWithCodes.stream().filter(userWithCode -> userWithCode.getWorkflowDefinitionCode() == pd.getCode() && userWithCode.getWorkflowDefinitionVersion() == pd.getVersion()).findAny().ifPresent(userWithCode -> {
                pd.setModifyBy(userWithCode.getModifierName());
                pd.setUserName(userWithCode.getCreatorName());
            });
            Schedule schedule = (Schedule)scheduleMap.get(pd.getCode());
            pd.setScheduleReleaseState(schedule == null ? null : schedule.getReleaseState());
            pd.setSchedule(schedule);
        }
        PageInfo<WorkflowDefinition> pageInfo = new PageInfo<WorkflowDefinition>(pageNo, pageSize);
        pageInfo.setTotal((int)workflowDefinitionPageListingResult.getTotalCount());
        pageInfo.setTotalList(workflowDefinitions);
        return pageInfo;
    }

    @Override
    public PageInfo<WorkflowDefinition> filterWorkflowDefinition(User loginUser, WorkflowFilterRequest workflowFilterRequest) {
        WorkflowDefinition workflowDefinition = workflowFilterRequest.convert2WorkflowDefinition();
        if (workflowFilterRequest.getProjectName() != null) {
            Project project = this.projectMapper.queryByName(workflowFilterRequest.getProjectName());
            this.projectService.checkProjectAndAuthThrowException(loginUser, project, "project:definition:list");
            workflowDefinition.setProjectCode(project.getCode());
        }
        Page page = new Page((long)workflowFilterRequest.getPageNo().intValue(), (long)workflowFilterRequest.getPageSize().intValue());
        IPage workflowDefinitionIPage = this.workflowDefinitionMapper.filterWorkflowDefinition((IPage)page, workflowDefinition);
        List records = workflowDefinitionIPage.getRecords();
        for (WorkflowDefinition pd : records) {
            WorkflowDefinitionLog workflowDefinitionLog = this.workflowDefinitionLogMapper.queryByDefinitionCodeAndVersion(pd.getCode(), pd.getVersion());
            User user = this.userMapper.selectById(workflowDefinitionLog.getOperator());
            pd.setModifyBy(user.getUserName());
        }
        workflowDefinitionIPage.setRecords(records);
        PageInfo<WorkflowDefinition> pageInfo = new PageInfo<WorkflowDefinition>(workflowFilterRequest.getPageNo(), workflowFilterRequest.getPageSize());
        pageInfo.setTotal((int)workflowDefinitionIPage.getTotal());
        pageInfo.setTotalList(workflowDefinitionIPage.getRecords());
        return pageInfo;
    }

    @Override
    public Map<String, Object> queryWorkflowDefinitionByCode(User loginUser, long projectCode, long code) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, "project:definition:list");
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        WorkflowDefinition workflowDefinition = this.workflowDefinitionMapper.queryByCode(code);
        if (workflowDefinition == null || projectCode != workflowDefinition.getProjectCode()) {
            log.error("workflow definition does not exist, workflowDefinitionCode:{}.", (Object)code);
            this.putMsg(result, Status.WORKFLOW_DEFINITION_NOT_EXIST, String.valueOf(code));
        } else {
            DagData dagData = this.processService.genDagData(workflowDefinition);
            result.put("data", dagData);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        return result;
    }

    @Override
    public WorkflowDefinition getWorkflowDefinition(User loginUser, long code) {
        WorkflowDefinition workflowDefinition = this.workflowDefinitionMapper.queryByCode(code);
        if (workflowDefinition == null) {
            throw new ServiceException(Status.WORKFLOW_DEFINITION_NOT_EXIST, String.valueOf(code));
        }
        Project project = this.projectMapper.queryByCode(workflowDefinition.getProjectCode());
        this.projectService.checkProjectAndAuthThrowException(loginUser, project, "project:definition:list");
        return workflowDefinition;
    }

    @Override
    public Optional<WorkflowDefinition> queryWorkflowDefinition(long workflowDefinitionCode, int workflowDefinitionVersion) {
        WorkflowDefinition workflowDefinition = this.workflowDefinitionDao.queryByCode(workflowDefinitionCode).orElse(null);
        if (workflowDefinition == null || workflowDefinition.getVersion() != workflowDefinitionVersion) {
            workflowDefinition = this.workflowDefinitionLogDao.queryByDefinitionCodeAndVersion(workflowDefinitionCode, workflowDefinitionVersion);
        }
        return Optional.ofNullable(workflowDefinition);
    }

    @Override
    public WorkflowDefinition queryWorkflowDefinitionThrowExceptionIfNotFound(long workflowDefinitionCode, int workflowDefinitionVersion) {
        return this.queryWorkflowDefinition(workflowDefinitionCode, workflowDefinitionVersion).orElseThrow(() -> new ServiceException(Status.WORKFLOW_DEFINITION_NOT_EXIST, String.valueOf(workflowDefinitionCode)));
    }

    @Override
    public Map<String, Object> queryWorkflowDefinitionByName(User loginUser, long projectCode, String name) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, "project:definition:list");
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        WorkflowDefinition workflowDefinition = this.workflowDefinitionMapper.queryByDefineName(projectCode, name);
        if (workflowDefinition == null) {
            log.error("workflow definition does not exist, projectCode:{}.", (Object)projectCode);
            this.putMsg(result, Status.WORKFLOW_DEFINITION_NOT_EXIST, name);
        } else {
            DagData dagData = this.processService.genDagData(workflowDefinition);
            result.put("data", dagData);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        return result;
    }

    @Override
    @Transactional
    public Map<String, Object> updateWorkflowDefinition(User loginUser, long projectCode, String name, long code, String description, String globalParams, String locations, int timeout, String taskRelationJson, String taskDefinitionJson, WorkflowExecutionTypeEnum executionType) {
        WorkflowDefinition definition;
        Map<String, Object> result;
        Project project = this.projectMapper.queryByCode(projectCode);
        boolean hasProjectAndWritePerm = this.projectService.hasProjectAndWritePerm(loginUser, project, result = new HashMap<String, Object>());
        if (!hasProjectAndWritePerm) {
            return result;
        }
        if (this.checkDescriptionLength(description)) {
            log.warn("Parameter description is too long.");
            this.putMsg(result, Status.DESCRIPTION_TOO_LONG_ERROR, new Object[0]);
            return result;
        }
        List<TaskDefinitionLog> taskDefinitionLogs = this.generateTaskDefinitionList(taskDefinitionJson);
        List<WorkflowTaskRelationLog> taskRelationList = this.generateTaskRelationList(taskRelationJson, taskDefinitionLogs);
        WorkflowDefinition workflowDefinition = this.workflowDefinitionMapper.queryByCode(code);
        if (workflowDefinition == null || projectCode != workflowDefinition.getProjectCode()) {
            log.error("workflow definition does not exist, workflowDefinitionCode:{}.", (Object)code);
            this.putMsg(result, Status.WORKFLOW_DEFINITION_NOT_EXIST, String.valueOf(code));
            return result;
        }
        if (workflowDefinition.getReleaseState() == ReleaseState.ONLINE) {
            log.warn("workflow definition is not allowed to be modified due to {}, workflowDefinitionCode:{}.", (Object)ReleaseState.ONLINE.getDescp(), (Object)workflowDefinition.getCode());
            this.putMsg(result, Status.WORKFLOW_DEFINITION_NOT_ALLOWED_EDIT, workflowDefinition.getName());
            return result;
        }
        if (!name.equals(workflowDefinition.getName()) && (definition = this.workflowDefinitionMapper.verifyByDefineName(project.getCode(), name)) != null) {
            log.warn("workflow definition with the same name already exists, workflowDefinitionCode:{}.", (Object)definition.getCode());
            this.putMsg(result, Status.WORKFLOW_DEFINITION_NAME_EXIST, name);
            return result;
        }
        WorkflowDefinition workflowDefinitionDeepCopy = (WorkflowDefinition)JSONUtils.parseObject((String)JSONUtils.toJsonString((Object)workflowDefinition), WorkflowDefinition.class);
        workflowDefinition.set(projectCode, name, description, globalParams, locations, timeout);
        workflowDefinition.setExecutionType(executionType);
        result = this.updateDagDefine(loginUser, taskRelationList, workflowDefinition, workflowDefinitionDeepCopy, taskDefinitionLogs);
        return result;
    }

    private void taskUsedInOtherTaskValid(WorkflowDefinition workflowDefinition, List<WorkflowTaskRelationLog> taskRelationList) {
        List oldWorkflowTaskRelationList = this.workflowTaskRelationMapper.queryByWorkflowDefinitionCode(workflowDefinition.getCode());
        Set oldWorkflowTaskRelationSet = oldWorkflowTaskRelationList.stream().map(WorkflowTaskRelationLog::new).collect(Collectors.toSet());
        StringBuilder sb = new StringBuilder();
        for (WorkflowTaskRelationLog oldWorkflowTaskRelation : oldWorkflowTaskRelationSet) {
            boolean oldTaskExists = taskRelationList.stream().anyMatch(relation -> oldWorkflowTaskRelation.getPostTaskCode() == relation.getPostTaskCode());
            if (!oldTaskExists) {
                Optional<String> taskDepMsg = this.workflowLineageService.taskDependentMsg(workflowDefinition.getProjectCode(), oldWorkflowTaskRelation.getWorkflowDefinitionCode(), oldWorkflowTaskRelation.getPostTaskCode());
                taskDepMsg.ifPresent(sb::append);
            }
            if (sb.length() == 0) continue;
            log.error("Task cannot be deleted because it is dependent");
            throw new ServiceException(sb.toString());
        }
    }

    protected Map<String, Object> updateDagDefine(User loginUser, List<WorkflowTaskRelationLog> taskRelationList, WorkflowDefinition workflowDefinition, WorkflowDefinition workflowDefinitionDeepCopy, List<TaskDefinitionLog> taskDefinitionLogs) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        int saveTaskResult = this.processService.saveTaskDefine(loginUser, workflowDefinition.getProjectCode(), taskDefinitionLogs, Boolean.TRUE);
        if (saveTaskResult == 0) {
            log.info("The task has not changed, so skip");
        }
        if (saveTaskResult == -1) {
            log.error("Update task definitions error, projectCode:{}, workflowDefinitionCode:{}.", (Object)workflowDefinition.getProjectCode(), (Object)workflowDefinition.getCode());
            this.putMsg(result, Status.UPDATE_TASK_DEFINITION_ERROR, new Object[0]);
            throw new ServiceException(Status.UPDATE_TASK_DEFINITION_ERROR);
        }
        boolean isChange = false;
        if (workflowDefinition.equals((Object)workflowDefinitionDeepCopy) && saveTaskResult == 0) {
            List workflowTaskRelationLogList = this.workflowTaskRelationLogMapper.queryByWorkflowCodeAndVersion(workflowDefinition.getCode(), workflowDefinition.getVersion());
            if (taskRelationList.size() == workflowTaskRelationLogList.size()) {
                HashSet<WorkflowTaskRelationLog> taskRelationSet = new HashSet<WorkflowTaskRelationLog>(taskRelationList);
                HashSet workflowTaskRelationLogSet = new HashSet(workflowTaskRelationLogList);
                if (taskRelationSet.size() == workflowTaskRelationLogSet.size()) {
                    taskRelationSet.removeAll(workflowTaskRelationLogSet);
                    if (!taskRelationSet.isEmpty()) {
                        isChange = true;
                    }
                } else {
                    isChange = true;
                }
            } else {
                isChange = true;
            }
        } else {
            isChange = true;
        }
        if (isChange) {
            log.info("workflow definition needs to be updated, projectCode:{}, workflowDefinitionCode:{}, workflowDefinitionVersion:{}.", new Object[]{workflowDefinition.getProjectCode(), workflowDefinition.getCode(), workflowDefinition.getVersion()});
            workflowDefinition.setUpdateTime(new Date());
            int insertVersion = this.processService.saveWorkflowDefine(loginUser, workflowDefinition, Boolean.TRUE, Boolean.TRUE);
            if (insertVersion <= 0) {
                log.error("Update workflow definition error, workflowDefinitionCode:{}.", (Object)workflowDefinition.getCode());
                this.putMsg(result, Status.UPDATE_WORKFLOW_DEFINITION_ERROR, new Object[0]);
                throw new ServiceException(Status.UPDATE_WORKFLOW_DEFINITION_ERROR);
            }
            log.info("Update workflow definition complete, workflowDefinitionCode:{}, workflowDefinitionVersion:{}.", (Object)workflowDefinition.getCode(), (Object)insertVersion);
            this.taskUsedInOtherTaskValid(workflowDefinition, taskRelationList);
            int insertResult = this.processService.saveTaskRelation(loginUser, workflowDefinition.getProjectCode(), workflowDefinition.getCode(), insertVersion, taskRelationList, taskDefinitionLogs, Boolean.TRUE);
            if (insertResult != 0) {
                log.error("Update workflow task relations error, projectCode:{}, workflowDefinitionCode:{}, workflowDefinitionVersion:{}.", new Object[]{workflowDefinition.getProjectCode(), workflowDefinition.getCode(), insertVersion});
                this.putMsg(result, Status.UPDATE_WORKFLOW_DEFINITION_ERROR, new Object[0]);
                throw new ServiceException(Status.UPDATE_WORKFLOW_DEFINITION_ERROR);
            }
            log.info("Update workflow task relations complete, projectCode:{}, workflowDefinitionCode:{}, workflowDefinitionVersion:{}.", new Object[]{workflowDefinition.getProjectCode(), workflowDefinition.getCode(), insertVersion});
            this.putMsg(result, Status.SUCCESS, new Object[0]);
            result.put("data", workflowDefinition);
            this.saveWorkflowLineage(workflowDefinition.getProjectCode(), workflowDefinition.getCode(), insertVersion, taskDefinitionLogs);
        } else {
            log.info("workflow definition does not need to be updated because there is no change, projectCode:{}, workflowDefinitionCode:{}, workflowDefinitionVersion:{}.", new Object[]{workflowDefinition.getProjectCode(), workflowDefinition.getCode(), workflowDefinition.getVersion()});
            this.putMsg(result, Status.SUCCESS, new Object[0]);
            result.put("data", workflowDefinition);
        }
        return result;
    }

    @Override
    public Map<String, Object> verifyWorkflowDefinitionName(User loginUser, long projectCode, String name, long workflowDefinitionCode) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, "project:definition:create");
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        WorkflowDefinition workflowDefinition = this.workflowDefinitionMapper.verifyByDefineName(project.getCode(), name.trim());
        if (workflowDefinition == null) {
            this.putMsg(result, Status.SUCCESS, new Object[0]);
            return result;
        }
        if (workflowDefinitionCode != 0L && workflowDefinitionCode == workflowDefinition.getCode()) {
            this.putMsg(result, Status.SUCCESS, new Object[0]);
            return result;
        }
        log.warn("workflow definition with the same name {} already exists, workflowDefinitionCode:{}.", (Object)workflowDefinition.getName(), (Object)workflowDefinition.getCode());
        this.putMsg(result, Status.WORKFLOW_DEFINITION_NAME_EXIST, name.trim());
        return result;
    }

    @Override
    @Transactional
    public Map<String, Object> batchDeleteWorkflowDefinitionByCodes(User loginUser, long projectCode, String codes) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (StringUtils.isEmpty((CharSequence)codes)) {
            log.error("Parameter workflowDefinitionCodes is empty, projectCode is {}.", (Object)projectCode);
            this.putMsg(result, Status.WORKFLOW_DEFINITION_CODES_IS_EMPTY, new Object[0]);
            return result;
        }
        Set definitionCodes = Lists.newArrayList((Object[])codes.split(",")).stream().map(Long::parseLong).collect(Collectors.toSet());
        List workflowDefinitionList = this.workflowDefinitionMapper.queryByCodes(definitionCodes);
        Set queryCodes = workflowDefinitionList.stream().map(WorkflowDefinition::getCode).collect(Collectors.toSet());
        Set diffCode = definitionCodes.stream().filter(code -> !queryCodes.contains(code)).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(diffCode)) {
            log.error("workflow definition does not exist, workflowDefinitionCodes:{}.", (Object)diffCode.stream().map(String::valueOf).collect(Collectors.joining(",")));
            throw new ServiceException(Status.BATCH_DELETE_WORKFLOW_DEFINE_BY_CODES_ERROR, diffCode.stream().map(code -> code + "[workflow definition not exist]").collect(Collectors.joining(",")));
        }
        for (WorkflowDefinition workflowDefinition : workflowDefinitionList) {
            try {
                this.deleteWorkflowDefinitionByCode(loginUser, workflowDefinition.getCode());
                this.metricsCleanUpService.cleanUpWorkflowMetricsByDefinitionCode(workflowDefinition.getCode());
            }
            catch (Exception e) {
                throw new ServiceException(Status.DELETE_WORKFLOW_DEFINE_ERROR, workflowDefinition.getName(), e.getMessage());
            }
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private void workflowDefinitionUsedInOtherTaskValid(WorkflowDefinition workflowDefinition) {
        if (workflowDefinition.getReleaseState() == ReleaseState.ONLINE) {
            throw new ServiceException(Status.WORKFLOW_DEFINE_STATE_ONLINE, workflowDefinition.getName());
        }
        List<WorkflowInstance> workflowInstances = this.workflowInstanceService.queryByWorkflowDefinitionCodeAndStatus(workflowDefinition.getCode(), WorkflowExecutionStatus.NOT_TERMINAL_STATES);
        if (CollectionUtils.isNotEmpty(workflowInstances)) {
            throw new ServiceException(Status.DELETE_WORKFLOW_DEFINITION_EXECUTING_FAIL, workflowInstances.size());
        }
        Optional<String> taskDepMsg = this.workflowLineageService.taskDependentMsg(workflowDefinition.getProjectCode(), workflowDefinition.getCode(), 0L);
        if (taskDepMsg.isPresent()) {
            String errorMeg = "workflow definition cannot be deleted because it has dependent, " + taskDepMsg.get();
            log.error(errorMeg);
            throw new ServiceException(errorMeg);
        }
    }

    @Override
    public void deleteWorkflowDefinitionByCode(User loginUser, long code) {
        WorkflowDefinition workflowDefinition = (WorkflowDefinition)this.workflowDefinitionDao.queryByCode(code).orElseThrow(() -> new ServiceException(Status.WORKFLOW_DEFINITION_NOT_EXIST, String.valueOf(code)));
        Project project = this.projectMapper.queryByCode(workflowDefinition.getProjectCode());
        this.projectService.checkProjectAndAuthThrowException(loginUser, project, "project:definition:version:delete");
        if (loginUser.getId().intValue() != workflowDefinition.getUserId() && loginUser.getUserType() != UserType.ADMIN_USER) {
            throw new ServiceException(Status.USER_NO_OPERATION_PERM);
        }
        this.workflowDefinitionUsedInOtherTaskValid(workflowDefinition);
        Schedule scheduleObj = this.scheduleMapper.queryByWorkflowDefinitionCode(code);
        if (scheduleObj != null) {
            int delete;
            if (scheduleObj.getReleaseState() == ReleaseState.OFFLINE && (delete = this.scheduleMapper.deleteById((Serializable)scheduleObj.getId())) == 0) {
                throw new ServiceException(Status.DELETE_SCHEDULE_BY_ID_ERROR);
            }
            if (scheduleObj.getReleaseState() == ReleaseState.ONLINE) {
                throw new ServiceException(Status.SCHEDULE_STATE_ONLINE, scheduleObj.getId());
            }
        }
        this.workflowInstanceService.deleteWorkflowInstanceByWorkflowDefinitionCode(workflowDefinition.getCode());
        this.taskDefinitionService.deleteTaskByWorkflowDefinitionCode(workflowDefinition.getCode(), workflowDefinition.getVersion());
        this.taskDefinitionLogService.deleteTaskByWorkflowDefinitionCode(workflowDefinition.getCode());
        this.workflowDefinitionLogDao.deleteByWorkflowDefinitionCode(workflowDefinition.getCode());
        this.workflowDefinitionDao.deleteByWorkflowDefinitionCode(workflowDefinition.getCode());
        this.metricsCleanUpService.cleanUpWorkflowMetricsByDefinitionCode(code);
        int deleteWorkflowLineageResult = this.workflowLineageService.deleteWorkflowLineage(Collections.singletonList(workflowDefinition.getCode()));
        if (deleteWorkflowLineageResult <= 0) {
            if (deleteWorkflowLineageResult < 0) {
                throw new ServiceException(Status.DELETE_WORKFLOW_LINEAGE_ERROR);
            }
            log.warn("No workflow lineage to delete, workflowDefinitionCode: {}", (Object)code);
        }
        log.info("Success delete workflow definition workflowDefinitionCode: {}", (Object)code);
    }

    @Override
    public void batchExportWorkflowDefinitionByCodes(User loginUser, long projectCode, String codes, HttpServletResponse response) {
        if (StringUtils.isEmpty((CharSequence)codes)) {
            log.warn("workflow definition codes to be exported is empty.");
            return;
        }
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, "project:definition:batch-export");
        if (result.get("status") != Status.SUCCESS) {
            return;
        }
        Set defineCodeSet = Lists.newArrayList((Object[])codes.split(",")).stream().map(Long::parseLong).collect(Collectors.toSet());
        List workflowDefinitionList = this.workflowDefinitionMapper.queryByCodes(defineCodeSet);
        if (CollectionUtils.isEmpty((Collection)workflowDefinitionList)) {
            log.error("workflow definitions to be exported do not exist, workflowDefinitionCodes:{}.", defineCodeSet);
            return;
        }
        List workflowDefinitionListInProject = workflowDefinitionList.stream().filter(o -> projectCode == o.getProjectCode()).collect(Collectors.toList());
        List<DagDataSchedule> dagDataSchedules = workflowDefinitionListInProject.stream().map(this::exportWorkflowDagData).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(dagDataSchedules)) {
            log.info("Start download workflow definition file, workflowDefinitionCodes:{}.", defineCodeSet);
            this.downloadWorkflowDefinitionFile(response, dagDataSchedules);
        } else {
            log.error("There is no exported workflow dag data.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void downloadWorkflowDefinitionFile(HttpServletResponse response, List<DagDataSchedule> dagDataSchedules) {
        response.setContentType("application/json;charset=UTF-8");
        BufferedOutputStream buff = null;
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
            buff = new BufferedOutputStream((OutputStream)out);
            buff.write(JSONUtils.toPrettyJsonString(dagDataSchedules).getBytes(StandardCharsets.UTF_8));
            buff.flush();
            buff.close();
        }
        catch (IOException e) {
            log.warn("Export workflow definition fail", (Throwable)e);
        }
        finally {
            if (null != buff) {
                try {
                    buff.close();
                }
                catch (Exception e) {
                    log.warn("Buffer does not close", (Throwable)e);
                }
            }
            if (null != out) {
                try {
                    out.close();
                }
                catch (Exception e) {
                    log.warn("Output stream does not close", (Throwable)e);
                }
            }
        }
    }

    public DagDataSchedule exportWorkflowDagData(WorkflowDefinition workflowDefinition) {
        Schedule scheduleObj = this.scheduleMapper.queryByWorkflowDefinitionCode(workflowDefinition.getCode());
        DagDataSchedule dagDataSchedule = new DagDataSchedule(this.processService.genDagData(workflowDefinition));
        if (scheduleObj != null) {
            scheduleObj.setReleaseState(ReleaseState.OFFLINE);
            dagDataSchedule.setSchedule(scheduleObj);
        }
        return dagDataSchedule;
    }

    @Override
    @Transactional
    public Map<String, Object> importWorkflowDefinition(User loginUser, long projectCode, MultipartFile file) {
        String dagDataScheduleJson = FileUtils.file2String(file);
        List dagDataScheduleList = JSONUtils.toList((String)dagDataScheduleJson, DagDataSchedule.class);
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, "project:definition:import");
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        if (CollectionUtils.isEmpty((Collection)dagDataScheduleList)) {
            log.warn("workflow definition file content is empty.");
            this.putMsg(result, Status.DATA_IS_NULL, "fileContent");
            return result;
        }
        for (DagDataSchedule dagDataSchedule : dagDataScheduleList) {
            if (this.checkAndImport(loginUser, projectCode, result, dagDataSchedule)) continue;
            return result;
        }
        return result;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    @Transactional
    public Map<String, Object> importSqlWorkflowDefinition(User loginUser, long projectCode, MultipartFile file) {
        WorkflowDefinition workflowDefinition;
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, "project:definition:import");
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        String workflowDefinitionName = file.getOriginalFilename() == null ? file.getName() : file.getOriginalFilename();
        int index = workflowDefinitionName.lastIndexOf(".");
        if (index > 0) {
            workflowDefinitionName = workflowDefinitionName.substring(0, index);
        }
        workflowDefinitionName = this.getNewName(workflowDefinitionName, "_import_");
        ArrayList<TaskDefinitionLog> taskDefinitionList = new ArrayList<TaskDefinitionLog>();
        ArrayList<WorkflowTaskRelationLog> workflowTaskRelationLogList = new ArrayList<WorkflowTaskRelationLog>();
        int THRESHOLD_ENTRIES = 10000;
        int THRESHOLD_SIZE = 1000000000;
        double THRESHOLD_RATIO = 10.0;
        int totalEntryArchive = 0;
        int totalSizeEntry = 0;
        HashMap<String, DataSource> dataSourceCache = new HashMap<String, DataSource>(1);
        HashMap<String, Long> taskNameToCode = new HashMap<String, Long>(16);
        HashMap taskNameToUpstream = new HashMap(16);
        try (ZipInputStream zIn = new ZipInputStream(file.getInputStream());){
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(zIn));
            Object object = null;
            try {
                ZipEntry entry;
                workflowDefinition = new WorkflowDefinition(projectCode, workflowDefinitionName, CodeGenerateUtils.genCode(), "", "[]", null, 0, loginUser.getId().intValue());
                while ((entry = zIn.getNextEntry()) != null) {
                    ++totalEntryArchive;
                    int totalSizeArchive = 0;
                    if (!entry.isDirectory()) {
                        DataSource dataSource;
                        String line;
                        StringBuilder sql = new StringBuilder();
                        String taskName = null;
                        String datasourceName = null;
                        List upstreams = Collections.emptyList();
                        while ((line = bufferedReader.readLine()) != null) {
                            int colonIndex;
                            int nBytes = line.getBytes(StandardCharsets.UTF_8).length;
                            totalSizeEntry += nBytes;
                            totalSizeArchive += nBytes;
                            long compressionRatio = (long)totalSizeEntry / entry.getCompressedSize();
                            if ((double)compressionRatio > 10.0) {
                                throw new IllegalStateException("Ratio between compressed and uncompressed data is highly suspicious, looks like a Zip Bomb Attack.");
                            }
                            int commentIndex = line.indexOf("-- ");
                            if (commentIndex >= 0 && (colonIndex = line.indexOf(":", commentIndex)) > 0) {
                                String key = line.substring(commentIndex + 3, colonIndex).trim().toLowerCase();
                                String value = line.substring(colonIndex + 1).trim();
                                switch (key) {
                                    case "name": {
                                        taskName = value;
                                        line = line.substring(0, commentIndex);
                                        break;
                                    }
                                    case "upstream": {
                                        upstreams = Arrays.stream(value.split(",")).map(String::trim).filter(s -> !"".equals(s)).collect(Collectors.toList());
                                        line = line.substring(0, commentIndex);
                                        break;
                                    }
                                    case "datasource": {
                                        datasourceName = value;
                                        line = line.substring(0, commentIndex);
                                        break;
                                    }
                                }
                            }
                            if ("".equals(line)) continue;
                            sql.append(line).append("\n");
                        }
                        if (taskName == null) {
                            taskName = entry.getName();
                            index = taskName.indexOf("/");
                            if (index > 0) {
                                taskName = taskName.substring(index + 1);
                            }
                            if ((index = taskName.lastIndexOf(".")) > 0) {
                                taskName = taskName.substring(0, index);
                            }
                        }
                        if ((dataSource = (DataSource)dataSourceCache.get(datasourceName)) == null) {
                            dataSource = this.queryDatasourceByNameAndUser(datasourceName, loginUser);
                        }
                        if (dataSource == null) {
                            log.error("Datasource does not found, may be its name is illegal.");
                            this.putMsg(result, Status.DATASOURCE_NAME_ILLEGAL, new Object[0]);
                            Map<String, Object> compressionRatio = result;
                            return compressionRatio;
                        }
                        dataSourceCache.put(datasourceName, dataSource);
                        TaskDefinitionLog taskDefinition = this.buildNormalSqlTaskDefinition(taskName, dataSource, sql.substring(0, sql.length() - 1));
                        taskDefinitionList.add(taskDefinition);
                        taskNameToCode.put(taskDefinition.getName(), taskDefinition.getCode());
                        taskNameToUpstream.put(taskDefinition.getName(), upstreams);
                    }
                    if (totalSizeArchive > 1000000000) {
                        throw new IllegalStateException("the uncompressed data size is too much for the application resource capacity");
                    }
                    if (totalEntryArchive <= 10000) continue;
                    throw new IllegalStateException("too much entries in this archive, can lead to inodes exhaustion of the system");
                }
            }
            catch (Throwable entry) {
                object = entry;
                throw entry;
            }
            finally {
                if (bufferedReader != null) {
                    if (object != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        bufferedReader.close();
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("Import workflow definition error.", (Throwable)e);
            this.putMsg(result, Status.IMPORT_WORKFLOW_DEFINE_ERROR, new Object[0]);
            return result;
        }
        for (Map.Entry entry : taskNameToCode.entrySet()) {
            List upstreams = (List)taskNameToUpstream.get(entry.getKey());
            if (CollectionUtils.isEmpty((Collection)upstreams) || upstreams.size() == 1 && upstreams.contains("root") && !taskNameToCode.containsKey("root")) {
                WorkflowTaskRelationLog workflowTaskRelationLog = this.buildNormalTaskRelation(0L, (Long)entry.getValue());
                workflowTaskRelationLogList.add(workflowTaskRelationLog);
                continue;
            }
            for (String upstream : upstreams) {
                WorkflowTaskRelationLog workflowTaskRelationLog = this.buildNormalTaskRelation((Long)taskNameToCode.get(upstream), (Long)entry.getValue());
                workflowTaskRelationLogList.add(workflowTaskRelationLog);
            }
        }
        return this.createDagDefine(loginUser, workflowTaskRelationLogList, workflowDefinition, taskDefinitionList);
    }

    private WorkflowTaskRelationLog buildNormalTaskRelation(long preTaskCode, long postTaskCode) {
        WorkflowTaskRelationLog workflowTaskRelationLog = new WorkflowTaskRelationLog();
        workflowTaskRelationLog.setPreTaskCode(preTaskCode);
        workflowTaskRelationLog.setPreTaskVersion(0);
        workflowTaskRelationLog.setPostTaskCode(postTaskCode);
        workflowTaskRelationLog.setPostTaskVersion(0);
        workflowTaskRelationLog.setConditionType(ConditionType.NONE);
        workflowTaskRelationLog.setName("");
        return workflowTaskRelationLog;
    }

    private DataSource queryDatasourceByNameAndUser(String datasourceName, User loginUser) {
        if (this.isAdmin(loginUser)) {
            List dataSources = this.dataSourceMapper.queryDataSourceByName(datasourceName);
            if (CollectionUtils.isNotEmpty((Collection)dataSources)) {
                return (DataSource)dataSources.get(0);
            }
        } else {
            return this.dataSourceMapper.queryDataSourceByNameAndUserId(loginUser.getId().intValue(), datasourceName);
        }
        return null;
    }

    private TaskDefinitionLog buildNormalSqlTaskDefinition(String taskName, DataSource dataSource, String sql) {
        TaskDefinitionLog taskDefinition = new TaskDefinitionLog();
        taskDefinition.setName(taskName);
        taskDefinition.setFlag(Flag.YES);
        SqlParameters sqlParameters = new SqlParameters();
        sqlParameters.setType(dataSource.getType().name());
        sqlParameters.setDatasource(dataSource.getId().intValue());
        sqlParameters.setSql(sql.substring(0, sql.length() - 1));
        sqlParameters.setSqlType(SqlType.NON_QUERY.ordinal());
        sqlParameters.setLocalParams(Collections.emptyList());
        taskDefinition.setTaskParams(JSONUtils.toJsonString((Object)sqlParameters));
        taskDefinition.setCode(CodeGenerateUtils.genCode());
        taskDefinition.setTaskType("SQL");
        taskDefinition.setFailRetryTimes(0);
        taskDefinition.setFailRetryInterval(0);
        taskDefinition.setTimeoutFlag(TimeoutFlag.CLOSE);
        taskDefinition.setWorkerGroup(WorkerGroupUtils.getDefaultWorkerGroup());
        taskDefinition.setTaskPriority(Priority.MEDIUM);
        taskDefinition.setEnvironmentCode(-1L);
        taskDefinition.setTimeout(0);
        taskDefinition.setDelayTime(0);
        taskDefinition.setTimeoutNotifyStrategy(TaskTimeoutStrategy.WARN);
        taskDefinition.setVersion(0);
        taskDefinition.setResourceIds("");
        return taskDefinition;
    }

    protected boolean checkAndImport(User loginUser, long projectCode, Map<String, Object> result, DagDataSchedule dagDataSchedule) {
        if (!this.checkImportanceParams(dagDataSchedule, result)) {
            return false;
        }
        WorkflowDefinition workflowDefinition = dagDataSchedule.getWorkflowDefinition();
        String workflowDefinitionName = this.recursionWorkflowDefinitionName(projectCode, workflowDefinition.getName(), 1);
        String importWorkflowDefinitionName = this.getNewName(workflowDefinitionName, "_import_");
        Map<String, Object> checkResult = this.verifyWorkflowDefinitionName(loginUser, projectCode, importWorkflowDefinitionName, 0L);
        if (!Status.SUCCESS.equals(checkResult.get("status"))) {
            result.putAll(checkResult);
            return false;
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        workflowDefinition.setName(importWorkflowDefinitionName);
        workflowDefinition.setId(null);
        workflowDefinition.setProjectCode(projectCode);
        workflowDefinition.setUserId(loginUser.getId().intValue());
        workflowDefinition.setCode(CodeGenerateUtils.genCode());
        List taskDefinitionList = dagDataSchedule.getTaskDefinitionList();
        HashMap<Long, Long> taskCodeMap = new HashMap<Long, Long>();
        Date now = new Date();
        ArrayList<TaskDefinitionLog> taskDefinitionLogList = new ArrayList<TaskDefinitionLog>();
        for (TaskDefinition taskDefinition : taskDefinitionList) {
            TaskDefinitionLog taskDefinitionLog = new TaskDefinitionLog(taskDefinition);
            taskDefinitionLog.setName(taskDefinitionLog.getName());
            taskDefinitionLog.setProjectCode(projectCode);
            taskDefinitionLog.setUserId(loginUser.getId().intValue());
            taskDefinitionLog.setVersion(1);
            taskDefinitionLog.setCreateTime(now);
            taskDefinitionLog.setUpdateTime(now);
            taskDefinitionLog.setOperator(loginUser.getId().intValue());
            taskDefinitionLog.setOperateTime(now);
            long code = CodeGenerateUtils.genCode();
            taskCodeMap.put(taskDefinitionLog.getCode(), code);
            taskDefinitionLog.setCode(code);
            taskDefinitionLogList.add(taskDefinitionLog);
        }
        int insert = this.taskDefinitionMapper.batchInsert(taskDefinitionLogList);
        int logInsert = this.taskDefinitionLogMapper.batchInsert(taskDefinitionLogList);
        if ((logInsert & insert) == 0) {
            log.error("Save task definition error, projectCode:{}, workflowDefinitionCode:{}", (Object)projectCode, (Object)workflowDefinition.getCode());
            this.putMsg(result, Status.CREATE_TASK_DEFINITION_ERROR, new Object[0]);
            throw new ServiceException(Status.CREATE_TASK_DEFINITION_ERROR);
        }
        List taskRelationList = dagDataSchedule.getWorkflowTaskRelationList();
        ArrayList<WorkflowTaskRelationLog> taskRelationLogList = new ArrayList<WorkflowTaskRelationLog>();
        for (WorkflowTaskRelation workflowTaskRelation : taskRelationList) {
            WorkflowTaskRelationLog workflowTaskRelationLog = new WorkflowTaskRelationLog(workflowTaskRelation);
            if (taskCodeMap.containsKey(workflowTaskRelationLog.getPreTaskCode())) {
                workflowTaskRelationLog.setPreTaskCode(((Long)taskCodeMap.get(workflowTaskRelationLog.getPreTaskCode())).longValue());
            }
            if (taskCodeMap.containsKey(workflowTaskRelationLog.getPostTaskCode())) {
                workflowTaskRelationLog.setPostTaskCode(((Long)taskCodeMap.get(workflowTaskRelationLog.getPostTaskCode())).longValue());
            }
            workflowTaskRelationLog.setPreTaskVersion(1);
            workflowTaskRelationLog.setPostTaskVersion(1);
            taskRelationLogList.add(workflowTaskRelationLog);
        }
        if (StringUtils.isNotEmpty((CharSequence)workflowDefinition.getLocations()) && JSONUtils.checkJsonValid((String)workflowDefinition.getLocations())) {
            ArrayNode arrayNode = JSONUtils.parseArray((String)workflowDefinition.getLocations());
            ArrayNode newArrayNode = JSONUtils.createArrayNode();
            for (int i = 0; i < arrayNode.size(); ++i) {
                ObjectNode newObjectNode = newArrayNode.addObject();
                JsonNode jsonNode = arrayNode.get(i);
                Long taskCode = (Long)taskCodeMap.get(jsonNode.get("taskCode").asLong());
                if (!Objects.nonNull(taskCode)) continue;
                newObjectNode.put("taskCode", taskCode);
                newObjectNode.set("x", jsonNode.get("x"));
                newObjectNode.set("y", jsonNode.get("y"));
            }
            workflowDefinition.setLocations(newArrayNode.toString());
        }
        workflowDefinition.setCreateTime(new Date());
        workflowDefinition.setUpdateTime(new Date());
        Map<String, Object> createDagResult = this.createDagDefine(loginUser, taskRelationLogList, workflowDefinition, Lists.newArrayList());
        if (!Status.SUCCESS.equals(createDagResult.get("status"))) {
            result.putAll(createDagResult);
            log.error("Import workflow definition error, projectCode:{}, workflowDefinitionCode:{}.", (Object)projectCode, (Object)workflowDefinition.getCode());
            throw new ServiceException(Status.IMPORT_WORKFLOW_DEFINE_ERROR);
        }
        this.putMsg(createDagResult, Status.SUCCESS, new Object[0]);
        Schedule schedule = dagDataSchedule.getSchedule();
        if (null != schedule) {
            WorkflowDefinition newWorkflowDefinition = this.workflowDefinitionMapper.queryByCode(workflowDefinition.getCode());
            schedule.setWorkflowDefinitionCode(newWorkflowDefinition.getCode());
            schedule.setId(null);
            schedule.setUserId(loginUser.getId().intValue());
            schedule.setCreateTime(now);
            schedule.setUpdateTime(now);
            schedule.setReleaseState(ReleaseState.OFFLINE);
            int scheduleInsert = this.scheduleMapper.insert(schedule);
            if (0 == scheduleInsert) {
                log.error("Import workflow definition error due to save schedule fail, projectCode:{}, workflowDefinitionCode:{}.", (Object)projectCode, (Object)workflowDefinition.getCode());
                this.putMsg(result, Status.IMPORT_WORKFLOW_DEFINE_ERROR, new Object[0]);
                throw new ServiceException(Status.IMPORT_WORKFLOW_DEFINE_ERROR);
            }
        }
        result.put("data", workflowDefinition);
        log.info("Import workflow definition complete, projectCode:{}, workflowDefinitionCode:{}.", (Object)projectCode, (Object)workflowDefinition.getCode());
        return true;
    }

    private boolean checkImportanceParams(DagDataSchedule dagDataSchedule, Map<String, Object> result) {
        if (dagDataSchedule.getWorkflowDefinition() == null) {
            log.warn("workflow definition is null.");
            this.putMsg(result, Status.DATA_IS_NULL, "WorkflowDefinition");
            return false;
        }
        if (CollectionUtils.isEmpty((Collection)dagDataSchedule.getTaskDefinitionList())) {
            log.warn("Task definition list is null.");
            this.putMsg(result, Status.DATA_IS_NULL, "TaskDefinitionList");
            return false;
        }
        if (CollectionUtils.isEmpty((Collection)dagDataSchedule.getWorkflowTaskRelationList())) {
            log.warn("workflow task relation list is null.");
            this.putMsg(result, Status.DATA_IS_NULL, "WorkflowTaskRelationList");
            return false;
        }
        return true;
    }

    private String recursionWorkflowDefinitionName(long projectCode, String workflowDefinitionName, int num) {
        WorkflowDefinition workflowDefinition = this.workflowDefinitionMapper.queryByDefineName(projectCode, workflowDefinitionName);
        if (workflowDefinition != null) {
            if (num > 1) {
                String str = workflowDefinitionName.substring(0, workflowDefinitionName.length() - 3);
                workflowDefinitionName = str + "(" + num + ")";
            } else {
                workflowDefinitionName = workflowDefinition.getName() + "(" + num + ")";
            }
        } else {
            return workflowDefinitionName;
        }
        return this.recursionWorkflowDefinitionName(projectCode, workflowDefinitionName, num + 1);
    }

    @Override
    public Map<String, Object> checkWorkflowNodeList(String workflowTaskRelationJson, List<TaskDefinitionLog> taskDefinitionLogsList) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            if (workflowTaskRelationJson == null) {
                log.error("workflow task relation data is null.");
                this.putMsg(result, Status.DATA_IS_NOT_VALID, workflowTaskRelationJson);
                return result;
            }
            List taskRelationList = JSONUtils.toList((String)workflowTaskRelationJson, WorkflowTaskRelation.class);
            List taskNodes = this.processService.transformTask(taskRelationList, taskDefinitionLogsList);
            if (CollectionUtils.isEmpty((Collection)taskNodes)) {
                log.error("Task node data is empty.");
                this.putMsg(result, Status.WORKFLOW_DAG_IS_EMPTY, new Object[0]);
                return result;
            }
            if (this.graphHasCycle(taskNodes)) {
                log.error("workflow DAG has cycle.");
                this.putMsg(result, Status.WORKFLOW_NODE_HAS_CYCLE, new Object[0]);
                return result;
            }
            for (TaskNode taskNode : taskNodes) {
                if (!TaskPluginManager.checkTaskParameters((String)taskNode.getType(), (String)taskNode.getParams())) {
                    this.putMsg(result, Status.WORKFLOW_NODE_S_PARAMETER_INVALID, taskNode.getName());
                    return result;
                }
                CheckUtils.checkOtherParams(taskNode.getExtras());
            }
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        catch (Exception e) {
            result.put("status", (Object)Status.INTERNAL_SERVER_ERROR_ARGS);
            this.putMsg(result, Status.INTERNAL_SERVER_ERROR_ARGS, e.getMessage());
            log.error(Status.INTERNAL_SERVER_ERROR_ARGS.getMsg(), (Throwable)e);
        }
        return result;
    }

    @Override
    public Map<String, Object> getTaskNodeListByDefinitionCode(User loginUser, long projectCode, long code) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, null);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        WorkflowDefinition workflowDefinition = this.workflowDefinitionMapper.queryByCode(code);
        if (workflowDefinition == null || projectCode != workflowDefinition.getProjectCode()) {
            log.error("workflow definition does not exist, workflowDefinitionCode:{}.", (Object)code);
            this.putMsg(result, Status.WORKFLOW_DEFINITION_NOT_EXIST, String.valueOf(code));
            return result;
        }
        DagData dagData = this.processService.genDagData(workflowDefinition);
        result.put("data", dagData.getTaskDefinitionList());
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> getNodeListMapByDefinitionCodes(User loginUser, long projectCode, String codes) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, null);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        Set defineCodeSet = Lists.newArrayList((Object[])codes.split(",")).stream().map(Long::parseLong).collect(Collectors.toSet());
        List workflowDefinitionList = this.workflowDefinitionMapper.queryByCodes(defineCodeSet);
        if (CollectionUtils.isEmpty((Collection)workflowDefinitionList)) {
            log.error("workflow definitions do not exist, codes:{}.", defineCodeSet);
            this.putMsg(result, Status.WORKFLOW_DEFINITION_NOT_EXIST, codes);
            return result;
        }
        HashMap userProjects = new HashMap(16);
        this.projectMapper.queryProjectCreatedAndAuthorizedByUserId(loginUser.getId().intValue()).forEach(userProject -> userProjects.put(userProject.getCode(), userProject));
        List workflowDefinitionListInProject = workflowDefinitionList.stream().filter(o -> userProjects.containsKey(o.getProjectCode())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(workflowDefinitionListInProject)) {
            Set codesInProject = workflowDefinitionListInProject.stream().map(WorkflowDefinition::getCode).collect(Collectors.toSet());
            log.error("workflow definitions do not exist in project, projectCode:{}, workflowDefinitionsCodes:{}.", (Object)((WorkflowDefinition)workflowDefinitionListInProject.get(0)).getProjectCode(), codesInProject);
            this.putMsg(result, Status.WORKFLOW_DEFINITION_NOT_EXIST, codes);
            return result;
        }
        HashMap<Long, List> taskNodeMap = new HashMap<Long, List>();
        for (WorkflowDefinition workflowDefinition : workflowDefinitionListInProject) {
            DagData dagData = this.processService.genDagData(workflowDefinition);
            taskNodeMap.put(workflowDefinition.getCode(), dagData.getTaskDefinitionList());
        }
        result.put("data", taskNodeMap);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> queryAllWorkflowDefinitionByProjectCode(User loginUser, long projectCode) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, "project:definition:list");
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        List workflowDefinitions = this.workflowDefinitionMapper.queryAllDefinitionList(projectCode);
        List dagDataList = workflowDefinitions.stream().map(arg_0 -> ((ProcessService)this.processService).genDagData(arg_0)).collect(Collectors.toList());
        result.put("data", dagDataList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> queryWorkflowDefinitionListByProjectCode(long projectCode) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List workflowDefinitions = this.workflowDefinitionMapper.queryDefinitionListByProjectCodeAndWorkflowDefinitionCodes(projectCode, null);
        result.put("data", workflowDefinitions);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> queryTaskDefinitionListByWorkflowDefinitionCode(long projectCode, Long workflowDefinitionCode) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashSet<Long> definitionCodesSet = new HashSet<Long>();
        definitionCodesSet.add(workflowDefinitionCode);
        List workflowDefinitions = this.workflowDefinitionMapper.queryDefinitionListByProjectCodeAndWorkflowDefinitionCodes(projectCode, definitionCodesSet);
        List taskDefinitionLogsList = this.taskDefinitionLogDao.queryByWorkflowDefinitionCodeAndVersion(((DependentSimplifyDefinition)workflowDefinitions.get(0)).getCode(), ((DependentSimplifyDefinition)workflowDefinitions.get(0)).getVersion());
        ArrayList<DependentSimplifyDefinition> taskDefinitionList = new ArrayList<DependentSimplifyDefinition>();
        for (TaskDefinitionLog taskDefinitionLog : taskDefinitionLogsList) {
            DependentSimplifyDefinition dependentSimplifyDefinition = new DependentSimplifyDefinition();
            dependentSimplifyDefinition.setCode(Long.valueOf(taskDefinitionLog.getCode()));
            dependentSimplifyDefinition.setName(taskDefinitionLog.getName());
            dependentSimplifyDefinition.setVersion(Integer.valueOf(taskDefinitionLog.getVersion()));
            taskDefinitionList.add(dependentSimplifyDefinition);
        }
        result.put("data", taskDefinitionList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> viewTree(User loginUser, long projectCode, long code, Integer limit) {
        Map<Object, Object> result = new HashMap();
        Project project = this.projectMapper.queryByCode(projectCode);
        result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, "project:definition:view-tree");
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        WorkflowDefinition workflowDefinition = this.workflowDefinitionMapper.queryByCode(code);
        if (null == workflowDefinition || projectCode != workflowDefinition.getProjectCode()) {
            log.error("workflow definition does not exist, code:{}.", (Object)code);
            this.putMsg(result, Status.WORKFLOW_DEFINITION_NOT_EXIST, String.valueOf(code));
            return result;
        }
        DAG dag = this.processService.genDagGraph(workflowDefinition);
        ConcurrentHashMap<Long, ArrayList<Object>> runningNodeMap = new ConcurrentHashMap<Long, ArrayList<Object>>();
        ConcurrentHashMap<Long, ArrayList<TreeViewDto>> waitingRunningNodeMap = new ConcurrentHashMap<Long, ArrayList<TreeViewDto>>();
        List<WorkflowInstance> workflowInstanceList = this.workflowInstanceService.queryByWorkflowDefinitionCode(code, limit);
        workflowInstanceList.forEach(workflowInstance -> workflowInstance.setDuration(DateUtils.format2Duration((Date)workflowInstance.getStartTime(), (Date)workflowInstance.getEndTime())));
        List taskDefinitionList = this.taskDefinitionLogDao.queryByWorkflowDefinitionCodeAndVersion(Long.valueOf(workflowDefinition.getCode()), Integer.valueOf(workflowDefinition.getVersion()));
        Map<Long, TaskDefinitionLog> taskDefinitionMap = taskDefinitionList.stream().collect(Collectors.toMap(TaskDefinition::getCode, taskDefinitionLog -> taskDefinitionLog));
        if (limit < 0) {
            this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, new Object[0]);
            return result;
        }
        if (limit > workflowInstanceList.size()) {
            limit = workflowInstanceList.size();
        }
        TreeViewDto parentTreeViewDto = new TreeViewDto();
        parentTreeViewDto.setName("DAG");
        parentTreeViewDto.setType("");
        parentTreeViewDto.setCode(0L);
        for (int i = limit - 1; i >= 0; --i) {
            WorkflowInstance workflowInstance2 = workflowInstanceList.get(i);
            Date endTime = workflowInstance2.getEndTime() == null ? new Date() : workflowInstance2.getEndTime();
            parentTreeViewDto.getInstances().add(new Instance(workflowInstance2.getId(), workflowInstance2.getName(), workflowInstance2.getWorkflowDefinitionCode(), "", workflowInstance2.getState().name(), workflowInstance2.getStartTime(), endTime, workflowInstance2.getHost(), DateUtils.format2Readable((long)(endTime.getTime() - workflowInstance2.getStartTime().getTime()))));
        }
        List parentTreeViewDtoList = new ArrayList<TreeViewDto>();
        parentTreeViewDtoList.add(parentTreeViewDto);
        for (Long startNode : dag.getBeginNode()) {
            runningNodeMap.put(startNode, (ArrayList<Object>)parentTreeViewDtoList);
        }
        while (!ServerLifeCycleManager.isStopped()) {
            for (Map.Entry en : runningNodeMap.entrySet()) {
                Long nodeCode = (Long)en.getKey();
                parentTreeViewDtoList = (List)en.getValue();
                TreeViewDto treeViewDto = new TreeViewDto();
                TaskNode taskNode = (TaskNode)dag.getNode((Object)nodeCode);
                treeViewDto.setType(taskNode.getType());
                treeViewDto.setCode(taskNode.getCode());
                treeViewDto.setName(taskNode.getName());
                for (int i = limit - 1; i >= 0; --i) {
                    WorkflowInstance workflowInstance3 = workflowInstanceList.get(i);
                    TaskInstance taskInstance = this.taskInstanceMapper.queryByInstanceIdAndCode(workflowInstance3.getId().intValue(), nodeCode);
                    if (taskInstance == null) {
                        treeViewDto.getInstances().add(new Instance(-1, "not running", 0L, "null"));
                        continue;
                    }
                    Date startTime = taskInstance.getStartTime() == null ? new Date() : taskInstance.getStartTime();
                    Date endTime = taskInstance.getEndTime() == null ? new Date() : taskInstance.getEndTime();
                    long subWorkflowCode = 0L;
                    if (TaskTypeUtils.isSubWorkflowTask((String)taskInstance.getTaskType())) {
                        TaskDefinition taskDefinition = (TaskDefinition)taskDefinitionMap.get(taskInstance.getTaskCode());
                        subWorkflowCode = Long.parseLong(JSONUtils.parseObject((String)taskDefinition.getTaskParams()).path("workflowDefinitionCode").asText());
                    }
                    treeViewDto.getInstances().add(new Instance(taskInstance.getId(), taskInstance.getName(), taskInstance.getTaskCode(), taskInstance.getTaskType(), taskInstance.getState().name(), taskInstance.getStartTime(), taskInstance.getEndTime(), taskInstance.getHost(), DateUtils.format2Readable((long)(endTime.getTime() - startTime.getTime())), subWorkflowCode));
                }
                for (TreeViewDto pTreeViewDto : parentTreeViewDtoList) {
                    pTreeViewDto.getChildren().add(treeViewDto);
                }
                Set postNodeList = dag.getSubsequentNodes((Object)nodeCode);
                if (CollectionUtils.isNotEmpty((Collection)postNodeList)) {
                    for (Long nextNodeCode : postNodeList) {
                        ArrayList<TreeViewDto> treeViewDtoList = (ArrayList<TreeViewDto>)waitingRunningNodeMap.get(nextNodeCode);
                        if (CollectionUtils.isEmpty((Collection)treeViewDtoList)) {
                            treeViewDtoList = new ArrayList<TreeViewDto>();
                        }
                        treeViewDtoList.add(treeViewDto);
                        waitingRunningNodeMap.put(nextNodeCode, treeViewDtoList);
                    }
                }
                runningNodeMap.remove(nodeCode);
            }
            if (waitingRunningNodeMap.size() == 0) break;
            runningNodeMap.putAll(waitingRunningNodeMap);
            waitingRunningNodeMap.clear();
        }
        result.put("data", parentTreeViewDto);
        result.put("status", (Object)Status.SUCCESS);
        result.put("msg", Status.SUCCESS.getMsg());
        return result;
    }

    private boolean graphHasCycle(List<TaskNode> taskNodeResponseList) {
        DAG graph = new DAG();
        for (TaskNode taskNodeResponse : taskNodeResponseList) {
            graph.addNode((Object)Long.toString(taskNodeResponse.getCode()), (Object)taskNodeResponse);
        }
        for (TaskNode taskNodeResponse : taskNodeResponseList) {
            List preTasks = JSONUtils.toList((String)taskNodeResponse.getPreTasks(), String.class);
            if (!CollectionUtils.isNotEmpty((Collection)preTasks)) continue;
            for (String preTask : preTasks) {
                if (graph.addEdge((Object)preTask, (Object)Long.toString(taskNodeResponse.getCode()))) continue;
                return true;
            }
        }
        return graph.hasCycle();
    }

    @Override
    @Transactional
    public Map<String, Object> batchCopyWorkflowDefinition(User loginUser, long projectCode, String codes, long targetProjectCode) {
        Map<String, Object> result = this.checkParams(loginUser, projectCode, codes, targetProjectCode, "project:definition:batch-copy");
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        ArrayList<String> failedWorkflowList = new ArrayList<String>();
        this.doBatchOperateWorkflowDefinition(loginUser, targetProjectCode, failedWorkflowList, codes, result, true);
        this.checkBatchOperateResult(projectCode, targetProjectCode, result, failedWorkflowList, true);
        return result;
    }

    @Override
    @Transactional
    public Map<String, Object> batchMoveWorkflowDefinition(User loginUser, long projectCode, String codes, long targetProjectCode) {
        Map<String, Object> result = this.checkParams(loginUser, projectCode, codes, targetProjectCode, "project:task-definition:move");
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        if (projectCode == targetProjectCode) {
            log.warn("Project code is same as target project code, projectCode:{}.", (Object)projectCode);
            return result;
        }
        ArrayList<String> failedWorkflowList = new ArrayList<String>();
        this.doBatchOperateWorkflowDefinition(loginUser, targetProjectCode, failedWorkflowList, codes, result, false);
        this.checkBatchOperateResult(projectCode, targetProjectCode, result, failedWorkflowList, false);
        return result;
    }

    private Map<String, Object> checkParams(User loginUser, long projectCode, String workflowDefinitionCodes, long targetProjectCode, String perm) {
        Project targetProject;
        Map<String, Object> targetResult;
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, perm);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        if (StringUtils.isEmpty((CharSequence)workflowDefinitionCodes)) {
            log.error("Parameter workflowDefinitionCodes is empty, projectCode is {}.", (Object)projectCode);
            this.putMsg(result, Status.WORKFLOW_DEFINITION_CODES_IS_EMPTY, workflowDefinitionCodes);
            return result;
        }
        if (projectCode != targetProjectCode && (targetResult = this.projectService.checkProjectAndAuth(loginUser, targetProject = this.projectMapper.queryByCode(targetProjectCode), targetProjectCode, perm)).get("status") != Status.SUCCESS) {
            return targetResult;
        }
        return result;
    }

    protected void doBatchOperateWorkflowDefinition(User loginUser, long targetProjectCode, List<String> failedWorkflowList, String workflowDefinitionCodes, Map<String, Object> result, boolean isCopy) {
        Set definitionCodes = Arrays.stream(workflowDefinitionCodes.split(",")).map(Long::parseLong).collect(Collectors.toSet());
        List workflowDefinitionList = this.workflowDefinitionMapper.queryByCodes(definitionCodes);
        Set queryCodes = workflowDefinitionList.stream().map(WorkflowDefinition::getCode).collect(Collectors.toSet());
        Set<Long> diffCode = definitionCodes.stream().filter(code -> !queryCodes.contains(code)).collect(Collectors.toSet());
        diffCode.forEach(code -> failedWorkflowList.add(code + "[null]"));
        for (WorkflowDefinition workflowDefinition : workflowDefinitionList) {
            List workflowTaskRelations = this.workflowTaskRelationMapper.queryByWorkflowDefinitionCode(workflowDefinition.getCode());
            List<WorkflowTaskRelationLog> taskRelationList = workflowTaskRelations.stream().map(WorkflowTaskRelationLog::new).collect(Collectors.toList());
            workflowDefinition.setProjectCode(targetProjectCode);
            if (isCopy) {
                Schedule scheduleObj;
                log.info("Copy workflow definition...");
                List taskDefinitionLogs = this.taskDefinitionLogDao.queryTaskDefineLogList(workflowTaskRelations);
                HashMap taskCodeMap = new HashMap();
                taskDefinitionLogs.forEach(taskDefinitionLog -> taskCodeMap.put(taskDefinitionLog.getCode(), CodeGenerateUtils.genCode()));
                for (TaskDefinitionLog taskDefinitionLog2 : taskDefinitionLogs) {
                    taskDefinitionLog2.setCode(((Long)taskCodeMap.get(taskDefinitionLog2.getCode())).longValue());
                    taskDefinitionLog2.setProjectCode(targetProjectCode);
                    taskDefinitionLog2.setVersion(0);
                    taskDefinitionLog2.setName(taskDefinitionLog2.getName());
                    if (!TaskTypeUtils.isSwitchTask((String)taskDefinitionLog2.getTaskType())) continue;
                    String taskParams = taskDefinitionLog2.getTaskParams();
                    SwitchParameters switchParameters = (SwitchParameters)JSONUtils.parseObject((String)taskParams, SwitchParameters.class);
                    if (switchParameters == null) {
                        throw new IllegalArgumentException("Switch task params: " + taskParams + " is invalid.");
                    }
                    SwitchParameters.SwitchResult switchResult = switchParameters.getSwitchResult();
                    switchResult.getDependTaskList().forEach(switchResultVo -> switchResultVo.setNextNode((Long)taskCodeMap.get(switchResultVo.getNextNode())));
                    if (switchResult.getNextNode() != null) {
                        switchResult.setNextNode((Long)taskCodeMap.get(switchResult.getNextNode()));
                    }
                    taskDefinitionLog2.setTaskParams(JSONUtils.toJsonString((Object)switchParameters));
                }
                for (WorkflowTaskRelationLog workflowTaskRelationLog : taskRelationList) {
                    if (workflowTaskRelationLog.getPreTaskCode() > 0L) {
                        workflowTaskRelationLog.setPreTaskCode(((Long)taskCodeMap.get(workflowTaskRelationLog.getPreTaskCode())).longValue());
                    }
                    if (workflowTaskRelationLog.getPostTaskCode() <= 0L) continue;
                    workflowTaskRelationLog.setPostTaskCode(((Long)taskCodeMap.get(workflowTaskRelationLog.getPostTaskCode())).longValue());
                }
                long oldWorkflowDefinitionCode = workflowDefinition.getCode();
                workflowDefinition.setCode(CodeGenerateUtils.genCode());
                workflowDefinition.setId(null);
                workflowDefinition.setUserId(loginUser.getId().intValue());
                workflowDefinition.setName(this.getNewName(workflowDefinition.getName(), "_copy_"));
                Date date = new Date();
                workflowDefinition.setCreateTime(date);
                workflowDefinition.setUpdateTime(date);
                workflowDefinition.setReleaseState(ReleaseState.OFFLINE);
                if (StringUtils.isNotBlank((CharSequence)workflowDefinition.getLocations())) {
                    ArrayNode jsonNodes = JSONUtils.parseArray((String)workflowDefinition.getLocations());
                    for (int i = 0; i < jsonNodes.size(); ++i) {
                        ObjectNode node = (ObjectNode)jsonNodes.path(i);
                        node.put("taskCode", (Long)taskCodeMap.get(node.get("taskCode").asLong()));
                        jsonNodes.set(i, (JsonNode)node);
                    }
                    workflowDefinition.setLocations(JSONUtils.toJsonString((Object)jsonNodes));
                }
                if ((scheduleObj = this.scheduleMapper.queryByWorkflowDefinitionCode(oldWorkflowDefinitionCode)) != null) {
                    scheduleObj.setId(null);
                    scheduleObj.setUserId(loginUser.getId().intValue());
                    scheduleObj.setWorkflowDefinitionCode(workflowDefinition.getCode());
                    scheduleObj.setReleaseState(ReleaseState.OFFLINE);
                    scheduleObj.setCreateTime(date);
                    scheduleObj.setUpdateTime(date);
                    int insertResult = this.scheduleMapper.insert(scheduleObj);
                    if (insertResult != 1) {
                        log.error("Schedule create error, workflowDefinitionCode:{}.", (Object)workflowDefinition.getCode());
                        this.putMsg(result, Status.CREATE_SCHEDULE_ERROR, new Object[0]);
                        throw new ServiceException(Status.CREATE_SCHEDULE_ERROR);
                    }
                }
                try {
                    result.putAll(this.createDagDefine(loginUser, taskRelationList, workflowDefinition, taskDefinitionLogs));
                }
                catch (Exception e) {
                    log.error("Copy workflow definition error, workflowDefinitionCode from {} to {}.", new Object[]{oldWorkflowDefinitionCode, workflowDefinition.getCode(), e});
                    this.putMsg(result, Status.COPY_WORKFLOW_DEFINITION_ERROR, new Object[0]);
                    throw new ServiceException(Status.COPY_WORKFLOW_DEFINITION_ERROR);
                }
            }
            log.info("Move workflow definition...");
            try {
                result.putAll(this.updateDagDefine(loginUser, taskRelationList, workflowDefinition, null, Lists.newArrayList()));
            }
            catch (Exception e) {
                log.error("Move workflow definition error, workflowDefinitionCode:{}.", (Object)workflowDefinition.getCode(), (Object)e);
                this.putMsg(result, Status.MOVE_WORKFLOW_DEFINITION_ERROR, new Object[0]);
                throw new ServiceException(Status.MOVE_WORKFLOW_DEFINITION_ERROR);
            }
            if (result.get("status") == Status.SUCCESS) continue;
            failedWorkflowList.add(workflowDefinition.getCode() + "[" + workflowDefinition.getName() + "]");
        }
    }

    public String getNewName(String originalName, String suffix) {
        StringBuilder newName = new StringBuilder();
        String regex = String.format(".*%s\\d{17}$", suffix);
        if (originalName.matches(regex)) {
            return newName.append(originalName, 0, originalName.lastIndexOf(suffix)).append(suffix).append(DateUtils.getCurrentTimeStamp()).toString();
        }
        return newName.append(originalName).append(suffix).append(DateUtils.getCurrentTimeStamp()).toString();
    }

    @Override
    @Transactional
    public Map<String, Object> switchWorkflowDefinitionVersion(User loginUser, long projectCode, long code, int version) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, "project:definition:version:switch");
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        WorkflowDefinition workflowDefinition = this.workflowDefinitionMapper.queryByCode(code);
        if (Objects.isNull(workflowDefinition) || projectCode != workflowDefinition.getProjectCode()) {
            log.error("Switch workflow definition error because it does not exist, projectCode:{}, workflowDefinitionCode:{}.", (Object)projectCode, (Object)code);
            this.putMsg(result, Status.SWITCH_WORKFLOW_DEFINITION_VERSION_NOT_EXIST_WORKFLOW_DEFINITION_ERROR, code);
            return result;
        }
        WorkflowDefinitionLog workflowDefinitionLog = this.workflowDefinitionLogMapper.queryByDefinitionCodeAndVersion(code, version);
        if (Objects.isNull(workflowDefinitionLog)) {
            log.error("Switch workflow definition error because version does not exist, projectCode:{}, workflowDefinitionCode:{}, version:{}.", new Object[]{projectCode, code, version});
            this.putMsg(result, Status.SWITCH_WORKFLOW_DEFINITION_VERSION_NOT_EXIST_WORKFLOW_DEFINITION_VERSION_ERROR, workflowDefinition.getCode(), version);
            return result;
        }
        int switchVersion = this.processService.switchVersion(workflowDefinition, workflowDefinitionLog);
        if (switchVersion <= 0) {
            log.error("Switch workflow definition version error, projectCode:{}, workflowDefinitionCode:{}, version:{}.", new Object[]{projectCode, code, version});
            this.putMsg(result, Status.SWITCH_WORKFLOW_DEFINITION_VERSION_ERROR, new Object[0]);
            throw new ServiceException(Status.SWITCH_WORKFLOW_DEFINITION_VERSION_ERROR);
        }
        List workflowTaskRelationList = this.workflowTaskRelationMapper.queryWorkflowTaskRelationsByWorkflowDefinitionCode(workflowDefinitionLog.getCode(), Integer.valueOf(workflowDefinitionLog.getVersion()));
        List<TaskCodeVersionDto> taskDefinitionList = WorkflowDefinitionServiceImpl.getTaskCodeVersionDtos(workflowTaskRelationList);
        List taskDefinitionLogList = this.taskDefinitionLogMapper.queryByTaskDefinitions((Collection)taskDefinitionList.stream().flatMap(taskCodeVersionDto -> {
            TaskDefinitionLog taskDefinitionLog = new TaskDefinitionLog();
            taskDefinitionLog.setCode(taskCodeVersionDto.getCode());
            taskDefinitionLog.setVersion(taskCodeVersionDto.getVersion());
            return Stream.of(taskDefinitionLog);
        }).collect(Collectors.toList()));
        this.saveWorkflowLineage(workflowDefinitionLog.getProjectCode(), workflowDefinitionLog.getCode(), workflowDefinitionLog.getVersion(), taskDefinitionLogList);
        log.info("Switch workflow definition version complete, projectCode:{}, workflowDefinitionCode:{}, version:{}.", new Object[]{projectCode, code, version});
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @NotNull
    private static List<TaskCodeVersionDto> getTaskCodeVersionDtos(List<WorkflowTaskRelation> workflowTaskRelationList) {
        ArrayList<TaskCodeVersionDto> taskDefinitionList = new ArrayList<TaskCodeVersionDto>();
        for (WorkflowTaskRelation workflowTaskRelation : workflowTaskRelationList) {
            TaskCodeVersionDto taskCodeVersionDto;
            if (workflowTaskRelation.getPreTaskCode() != 0L) {
                taskCodeVersionDto = new TaskCodeVersionDto();
                taskCodeVersionDto.setCode(workflowTaskRelation.getPreTaskCode());
                taskCodeVersionDto.setVersion(workflowTaskRelation.getPreTaskVersion());
                taskDefinitionList.add(taskCodeVersionDto);
            }
            if (workflowTaskRelation.getPostTaskCode() == 0L) continue;
            taskCodeVersionDto = new TaskCodeVersionDto();
            taskCodeVersionDto.setCode(workflowTaskRelation.getPostTaskCode());
            taskCodeVersionDto.setVersion(workflowTaskRelation.getPostTaskVersion());
            taskDefinitionList.add(taskCodeVersionDto);
        }
        return taskDefinitionList;
    }

    private void checkBatchOperateResult(long srcProjectCode, long targetProjectCode, Map<String, Object> result, List<String> failedWorkflowList, boolean isCopy) {
        if (!failedWorkflowList.isEmpty()) {
            String failedWorkflow = String.join((CharSequence)",", failedWorkflowList);
            if (isCopy) {
                log.error("Copy workflow definition error, srcProjectCode:{}, targetProjectCode:{}, failedWorkflowList:{}.", new Object[]{srcProjectCode, targetProjectCode, failedWorkflow});
                this.putMsg(result, Status.COPY_WORKFLOW_DEFINITION_ERROR, srcProjectCode, targetProjectCode, failedWorkflow);
            } else {
                log.error("Move workflow definition error, srcProjectCode:{}, targetProjectCode:{}, failedWorkflowList:{}.", new Object[]{srcProjectCode, targetProjectCode, failedWorkflow});
                this.putMsg(result, Status.MOVE_WORKFLOW_DEFINITION_ERROR, srcProjectCode, targetProjectCode, failedWorkflow);
            }
        } else {
            log.info("Batch {} workflow definition complete, srcProjectCode:{}, targetProjectCode:{}.", new Object[]{isCopy ? "copy" : "move", srcProjectCode, targetProjectCode});
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
    }

    @Override
    public Result queryWorkflowDefinitionVersions(User loginUser, long projectCode, int pageNo, int pageSize, long code) {
        Result result = new Result();
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> checkResult = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, "project:version:list");
        Status resultStatus = (Status)((Object)checkResult.get("status"));
        if (resultStatus != Status.SUCCESS) {
            this.putMsg(result, resultStatus, new Object[0]);
            return result;
        }
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        Page page = new Page((long)pageNo, (long)pageSize);
        IPage workflowDefinitionLogIPage = this.workflowDefinitionLogMapper.queryWorkflowDefinitionVersionsPaging(page, code, projectCode);
        List workflowDefinitionLogs = workflowDefinitionLogIPage.getRecords();
        pageInfo.setTotalList(workflowDefinitionLogs);
        pageInfo.setTotal((int)workflowDefinitionLogIPage.getTotal());
        result.setData(pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    @Transactional
    public void deleteWorkflowDefinitionVersion(User loginUser, long projectCode, long code, int version) {
        this.projectService.checkHasProjectWritePermissionThrowException(loginUser, projectCode);
        WorkflowDefinition workflowDefinition = this.workflowDefinitionMapper.queryByCode(code);
        if (workflowDefinition == null || projectCode != workflowDefinition.getProjectCode()) {
            throw new ServiceException(Status.WORKFLOW_DEFINITION_NOT_EXIST, code);
        }
        if (workflowDefinition.getVersion() == version) {
            log.warn("This version: {} of workflow: {} is the main version cannot delete by version", (Object)code, (Object)version);
            throw new ServiceException(Status.MAIN_TABLE_USING_VERSION);
        }
        List<WorkflowInstance> workflowInstances = this.workflowInstanceService.queryByWorkflowCodeVersionStatus(code, version, WorkflowExecutionStatus.NOT_TERMINAL_STATES);
        if (CollectionUtils.isNotEmpty(workflowInstances)) {
            throw new ServiceException(Status.DELETE_WORKFLOW_DEFINITION_EXECUTING_FAIL, workflowInstances.size());
        }
        int deleteLog = this.workflowDefinitionLogMapper.deleteByWorkflowDefinitionCodeAndVersion(code, version);
        int deleteRelationLog = this.workflowTaskRelationLogMapper.deleteByCode(code, version);
        if (deleteLog == 0 || deleteRelationLog == 0) {
            throw new ServiceException(Status.DELETE_WORKFLOW_DEFINE_BY_CODE_ERROR);
        }
        log.info("Delete version: {} of workflow: {}, projectCode: {}", new Object[]{version, code, projectCode});
    }

    private void updateWorkflowValid(User user, WorkflowDefinition oldWorkflowDefinition, WorkflowDefinition newWorkflowDefinition) {
        WorkflowDefinition definition;
        if (oldWorkflowDefinition.getReleaseState() == ReleaseState.ONLINE) {
            throw new ServiceException(Status.WORKFLOW_DEFINITION_NOT_ALLOWED_EDIT, oldWorkflowDefinition.getName());
        }
        Project project = this.projectMapper.queryByCode(oldWorkflowDefinition.getProjectCode());
        this.projectService.checkProjectAndAuthThrowException(user, project, "project:definition:update");
        if (this.checkDescriptionLength(newWorkflowDefinition.getDescription())) {
            throw new ServiceException(Status.DESCRIPTION_TOO_LONG_ERROR);
        }
        if (!oldWorkflowDefinition.getName().equals(newWorkflowDefinition.getName()) && (definition = this.workflowDefinitionMapper.verifyByDefineName(newWorkflowDefinition.getProjectCode(), newWorkflowDefinition.getName())) != null) {
            throw new ServiceException(Status.WORKFLOW_DEFINITION_NAME_EXIST, newWorkflowDefinition.getName());
        }
    }

    @Override
    @Transactional
    public WorkflowDefinition updateSingleWorkflowDefinition(User loginUser, long workflowCode, WorkflowUpdateRequest workflowUpdateRequest) {
        WorkflowDefinition workflowDefinition = this.workflowDefinitionMapper.queryByCode(workflowCode);
        if (workflowDefinition == null) {
            throw new ServiceException(Status.WORKFLOW_DEFINITION_NOT_EXIST, workflowCode);
        }
        WorkflowDefinition workflowDefinitionUpdate = workflowUpdateRequest.mergeIntoWorkflowDefinition(workflowDefinition);
        this.updateWorkflowValid(loginUser, workflowDefinition, workflowDefinitionUpdate);
        int insertVersion = this.saveWorkflowDefine(loginUser, workflowDefinitionUpdate);
        if (insertVersion == 0) {
            log.error("Update workflow definition error, projectCode:{}, workflowDefinitionName:{}.", (Object)workflowDefinitionUpdate.getCode(), (Object)workflowDefinitionUpdate.getName());
            throw new ServiceException(Status.UPDATE_WORKFLOW_DEFINITION_ERROR);
        }
        int insertRelationVersion = this.saveTaskRelation(loginUser, workflowDefinitionUpdate, insertVersion);
        if (insertRelationVersion != 0) {
            log.error("Save workflow task relations error, projectCode:{}, workflowDefinitionCode:{}, workflowDefinitionVersion:{}.", new Object[]{workflowDefinition.getProjectCode(), workflowDefinition.getCode(), insertVersion});
            throw new ServiceException(Status.CREATE_WORKFLOW_TASK_RELATION_ERROR);
        }
        log.info("Save workflow task relations complete, projectCode:{}, workflowDefinitionCode:{}, workflowDefinitionVersion:{}.", new Object[]{workflowDefinition.getProjectCode(), workflowDefinition.getCode(), insertVersion});
        workflowDefinitionUpdate.setVersion(insertVersion);
        return workflowDefinitionUpdate;
    }

    public int saveWorkflowDefine(User loginUser, WorkflowDefinition workflowDefinition) {
        WorkflowDefinitionLog workflowDefinitionLog = new WorkflowDefinitionLog(workflowDefinition);
        Integer version = this.workflowDefinitionLogMapper.queryMaxVersionForDefinition(workflowDefinition.getCode());
        int insertVersion = version == null || version == 0 ? 1 : version + 1;
        workflowDefinitionLog.setVersion(insertVersion);
        workflowDefinition.setVersion(insertVersion);
        workflowDefinitionLog.setOperator(loginUser.getId().intValue());
        workflowDefinition.setUserId(loginUser.getId().intValue());
        workflowDefinitionLog.setOperateTime(workflowDefinition.getUpdateTime());
        workflowDefinition.setUpdateTime(workflowDefinition.getUpdateTime());
        workflowDefinitionLog.setId(null);
        int result = this.workflowDefinitionMapper.updateById(workflowDefinition);
        int insertLog = this.workflowDefinitionLogMapper.insert((Object)workflowDefinitionLog);
        workflowDefinitionLog.setId(workflowDefinition.getId());
        return (insertLog & result) > 0 ? insertVersion : 0;
    }

    public int saveTaskRelation(User loginUser, WorkflowDefinition workflowDefinition, int workflowDefinitionVersion) {
        int resultLog;
        List workflowTaskRelations;
        int insert;
        long projectCode = workflowDefinition.getProjectCode();
        long workflowDefinitionCode = workflowDefinition.getCode();
        List taskRelations = this.workflowTaskRelationMapper.queryByWorkflowDefinitionCode(workflowDefinitionCode);
        List taskRelationList = taskRelations.stream().map(WorkflowTaskRelationLog::new).collect(Collectors.toList());
        List taskCodeList = taskRelations.stream().map(WorkflowTaskRelation::getPostTaskCode).collect(Collectors.toList());
        List taskDefinitions = this.taskDefinitionMapper.queryByCodeList(taskCodeList);
        List taskDefinitionLogs = taskDefinitions.stream().map(TaskDefinitionLog::new).collect(Collectors.toList());
        if (taskRelationList.isEmpty()) {
            return 0;
        }
        Map<Long, TaskDefinitionLog> taskDefinitionLogMap = null;
        if (CollectionUtils.isNotEmpty(taskDefinitionLogs)) {
            taskDefinitionLogMap = taskDefinitionLogs.stream().collect(Collectors.toMap(TaskDefinition::getCode, taskDefinitionLog -> taskDefinitionLog));
        }
        Date now = new Date();
        for (WorkflowTaskRelationLog workflowTaskRelationLog : taskRelationList) {
            workflowTaskRelationLog.setProjectCode(projectCode);
            workflowTaskRelationLog.setWorkflowDefinitionCode(workflowDefinitionCode);
            workflowTaskRelationLog.setWorkflowDefinitionVersion(workflowDefinitionVersion);
            if (taskDefinitionLogMap != null) {
                TaskDefinitionLog postTaskDefinitionLog;
                TaskDefinitionLog preTaskDefinitionLog = taskDefinitionLogMap.get(workflowTaskRelationLog.getPreTaskCode());
                if (preTaskDefinitionLog != null) {
                    workflowTaskRelationLog.setPreTaskVersion(preTaskDefinitionLog.getVersion());
                }
                if ((postTaskDefinitionLog = taskDefinitionLogMap.get(workflowTaskRelationLog.getPostTaskCode())) != null) {
                    workflowTaskRelationLog.setPostTaskVersion(postTaskDefinitionLog.getVersion());
                }
            }
            workflowTaskRelationLog.setCreateTime(now);
            workflowTaskRelationLog.setUpdateTime(now);
            workflowTaskRelationLog.setOperator(loginUser.getId().intValue());
            workflowTaskRelationLog.setOperateTime(now);
        }
        if (!taskRelations.isEmpty()) {
            Set taskRelationSet;
            Set workflowTaskRelationSet = taskRelations.stream().map(WorkflowTaskRelation::hashCode).collect(Collectors.toSet());
            boolean isSame = CollectionUtils.isEqualCollection(workflowTaskRelationSet, taskRelationSet = taskRelationList.stream().map(WorkflowTaskRelationLog::hashCode).collect(Collectors.toSet()));
            if (isSame) {
                log.info("workflow task relations is non-existent, projectCode:{}, workflowDefinitionCode:{}.", (Object)workflowDefinition.getProjectCode(), (Object)workflowDefinition.getCode());
                return 0;
            }
            this.workflowTaskRelationMapper.deleteByWorkflowDefinitionCode(projectCode, workflowDefinitionCode);
        }
        return ((insert = this.workflowTaskRelationMapper.batchInsert(workflowTaskRelations = taskRelationList.stream().map(WorkflowTaskRelation::new).collect(Collectors.toList()))) & (resultLog = this.workflowTaskRelationLogMapper.batchInsert(taskRelationList))) > 0 ? 0 : -1;
    }

    @Override
    @Transactional
    public void onlineWorkflowDefinition(User loginUser, Long projectCode, Long workflowDefinitionCode) {
        this.projectService.checkProjectAndAuthThrowException(loginUser, projectCode, "project:definition:release");
        WorkflowDefinition workflowDefinition = (WorkflowDefinition)this.workflowDefinitionDao.queryByCode(workflowDefinitionCode.longValue()).orElseThrow(() -> new ServiceException(Status.WORKFLOW_DEFINITION_NOT_EXIST, workflowDefinitionCode));
        if (ReleaseState.ONLINE.equals((Object)workflowDefinition.getReleaseState())) {
            return;
        }
        this.checkWorkflowDefinitionIsValidated(workflowDefinition.getCode());
        this.checkAllSubWorkflowDefinitionIsOnline(workflowDefinition.getCode());
        workflowDefinition.setReleaseState(ReleaseState.ONLINE);
        this.workflowDefinitionDao.updateById((Object)workflowDefinition);
    }

    @Override
    @Transactional
    public void offlineWorkflowDefinition(User loginUser, Long projectCode, Long workflowDefinitionCode) {
        this.projectService.checkProjectAndAuthThrowException(loginUser, projectCode, "project:definition:release");
        WorkflowDefinition workflowDefinition = (WorkflowDefinition)this.workflowDefinitionDao.queryByCode(workflowDefinitionCode.longValue()).orElseThrow(() -> new ServiceException(Status.WORKFLOW_DEFINITION_NOT_EXIST, workflowDefinitionCode));
        if (ReleaseState.OFFLINE.equals((Object)workflowDefinition.getReleaseState())) {
            return;
        }
        workflowDefinition.setReleaseState(ReleaseState.OFFLINE);
        this.workflowDefinitionDao.updateById((Object)workflowDefinition);
        this.schedulerService.offlineSchedulerByWorkflowCode(workflowDefinitionCode);
    }

    @Override
    public Map<String, Object> viewVariables(User loginUser, long projectCode, long code) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, "project:definition:list");
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        WorkflowDefinition workflowDefinition = this.workflowDefinitionMapper.queryByCode(code);
        if (Objects.isNull(workflowDefinition) || projectCode != workflowDefinition.getProjectCode()) {
            log.error("workflow definition does not exist, projectCode:{}, workflowDefinitionCode:{}.", (Object)projectCode, (Object)code);
            this.putMsg(result, Status.WORKFLOW_DEFINITION_NOT_EXIST, code);
            return result;
        }
        List globalParams = workflowDefinition.getGlobalParamList();
        Map<String, Map<String, Object>> localUserDefParams = this.getLocalParams(workflowDefinition);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (Objects.nonNull(globalParams)) {
            resultMap.put("globalParams", globalParams);
        }
        if (Objects.nonNull(localUserDefParams)) {
            resultMap.put("localParams", localUserDefParams);
        }
        result.put("data", resultMap);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private Map<String, Map<String, Object>> getLocalParams(WorkflowDefinition workflowDefinition) {
        HashMap<String, Map<String, Object>> localUserDefParams = new HashMap<String, Map<String, Object>>();
        TreeSet taskCodeSet = new TreeSet();
        this.workflowTaskRelationMapper.queryByWorkflowDefinitionCode(workflowDefinition.getCode()).forEach(processTaskRelation -> {
            if (processTaskRelation.getPreTaskCode() > 0L) {
                taskCodeSet.add(processTaskRelation.getPreTaskCode());
            }
            if (processTaskRelation.getPostTaskCode() > 0L) {
                taskCodeSet.add(processTaskRelation.getPostTaskCode());
            }
        });
        this.taskDefinitionMapper.queryByCodeList(taskCodeSet).stream().forEach(taskDefinition -> {
            HashMap<String, Object> localParamsMap = new HashMap<String, Object>();
            String localParams = JSONUtils.getNodeString((String)taskDefinition.getTaskParams(), (String)"localParams");
            if (!StringUtils.isEmpty((CharSequence)localParams)) {
                List localParamsList = JSONUtils.toList((String)localParams, Property.class);
                localParamsMap.put("taskType", taskDefinition.getTaskType());
                localParamsMap.put("localParamsList", localParamsList);
                if (CollectionUtils.isNotEmpty((Collection)localParamsList)) {
                    localUserDefParams.put(taskDefinition.getName(), localParamsMap);
                }
            }
        });
        return localUserDefParams;
    }

    private void checkWorkflowDefinitionIsValidated(Long workflowDefinitionCode) {
        List workflowTaskRelations = this.workflowTaskRelationMapper.queryByWorkflowDefinitionCode(workflowDefinitionCode.longValue());
        if (CollectionUtils.isEmpty((Collection)workflowTaskRelations)) {
            throw new ServiceException(Status.WORKFLOW_DAG_IS_EMPTY);
        }
    }

    private void checkAllSubWorkflowDefinitionIsOnline(Long workflowDefinitionCode) {
        List allSubWorkflowDefinitionCodes = this.processService.findAllSubWorkflowDefinitionCode(workflowDefinitionCode.longValue());
        if (CollectionUtils.isEmpty((Collection)allSubWorkflowDefinitionCodes)) {
            return;
        }
        for (Long subWorkflowDefinitionCode : allSubWorkflowDefinitionCodes) {
            WorkflowDefinition subWorkflowDefinition = (WorkflowDefinition)this.workflowDefinitionDao.queryByCode(subWorkflowDefinitionCode.longValue()).orElseThrow(() -> new ServiceException(Status.WORKFLOW_DEFINITION_NOT_EXIST, workflowDefinitionCode));
            if (ReleaseState.ONLINE.equals((Object)subWorkflowDefinition.getReleaseState())) continue;
            throw new ServiceException("SubWorkflowDefinition " + subWorkflowDefinition.getName() + " is not online");
        }
    }
}

