/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.interceptor;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.RateLimiter;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.configuration.ApiConfig;
import org.apache.dolphinscheduler.common.utils.MaskUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.servlet.HandlerInterceptor;

public class RateLimitInterceptor
implements HandlerInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RateLimitInterceptor.class);
    private ApiConfig.TrafficConfiguration trafficConfiguration;
    private RateLimiter globalRateLimiter;
    private LoadingCache<String, RateLimiter> tenantRateLimiterCache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterAccess(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, RateLimiter>(){

        public RateLimiter load(String token) {
            Map<String, Integer> customizeTenantQpsRate = RateLimitInterceptor.this.trafficConfiguration.getCustomizeTenantQpsRate();
            int tenantQuota = RateLimitInterceptor.this.trafficConfiguration.getDefaultTenantQpsRate();
            if (MapUtils.isNotEmpty(customizeTenantQpsRate)) {
                tenantQuota = customizeTenantQpsRate.getOrDefault(token, RateLimitInterceptor.this.trafficConfiguration.getDefaultTenantQpsRate());
            }
            return RateLimiter.create((double)tenantQuota, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
    });

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws ExecutionException {
        RateLimiter tenantRateLimiter;
        String token;
        if (this.trafficConfiguration.isTenantSwitch() && StringUtils.isNotEmpty((CharSequence)(token = request.getHeader("token"))) && !(tenantRateLimiter = (RateLimiter)this.tenantRateLimiterCache.get((Object)token)).tryAcquire()) {
            response.setStatus(HttpStatus.TOO_MANY_REQUESTS.value());
            log.warn("Too many request, reach tenant token: {} rate limit, current tenant qps is {}", (Object)MaskUtils.maskString((String)token, (int)6), (Object)tenantRateLimiter.getRate());
            return false;
        }
        if (this.trafficConfiguration.isGlobalSwitch() && !this.globalRateLimiter.tryAcquire()) {
            response.setStatus(HttpStatus.TOO_MANY_REQUESTS.value());
            log.warn("Too many request, reach global rate limit, current global qps is {}", (Object)this.globalRateLimiter.getRate());
            return false;
        }
        return true;
    }

    public RateLimitInterceptor(ApiConfig.TrafficConfiguration trafficConfiguration) {
        this.trafficConfiguration = trafficConfiguration;
        if (trafficConfiguration.isGlobalSwitch()) {
            this.globalRateLimiter = RateLimiter.create((double)trafficConfiguration.getMaxGlobalQpsRate().intValue(), (long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
    }
}

