/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventhubs.implementation;

import com.azure.resourcemanager.eventhubs.EventHubsManager;
import com.azure.resourcemanager.eventhubs.fluent.models.AccessKeysInner;
import com.azure.resourcemanager.eventhubs.fluent.models.AuthorizationRuleInner;
import com.azure.resourcemanager.eventhubs.implementation.EventHubAuthorizationKeyImpl;
import com.azure.resourcemanager.eventhubs.implementation.NestedResourceImpl;
import com.azure.resourcemanager.eventhubs.models.AccessRights;
import com.azure.resourcemanager.eventhubs.models.AuthorizationRule;
import com.azure.resourcemanager.eventhubs.models.EventHubAuthorizationKey;
import com.azure.resourcemanager.eventhubs.models.KeyType;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import reactor.core.publisher.Mono;

abstract class AuthorizationRuleBaseImpl<RuleT extends AuthorizationRule<RuleT>, RuleImpl extends IndexableRefreshableWrapperImpl<RuleT, AuthorizationRuleInner>>
extends NestedResourceImpl<RuleT, AuthorizationRuleInner, RuleImpl>
implements AuthorizationRule<RuleT> {
    protected AuthorizationRuleBaseImpl(String name, AuthorizationRuleInner inner, EventHubsManager manager) {
        super(name, inner, manager);
    }

    @Override
    public Mono<EventHubAuthorizationKey> getKeysAsync() {
        return this.getKeysInnerAsync().map(EventHubAuthorizationKeyImpl::new);
    }

    @Override
    public EventHubAuthorizationKey getKeys() {
        return (EventHubAuthorizationKey)this.getKeysAsync().block();
    }

    @Override
    public Mono<EventHubAuthorizationKey> regenerateKeyAsync(KeyType keyType) {
        return this.regenerateKeysInnerAsync(keyType).map(EventHubAuthorizationKeyImpl::new);
    }

    @Override
    public EventHubAuthorizationKey regenerateKey(KeyType keyType) {
        return (EventHubAuthorizationKey)this.regenerateKeyAsync(keyType).block();
    }

    @Override
    public List<AccessRights> rights() {
        if (((AuthorizationRuleInner)((Object)this.innerModel())).rights() == null) {
            return Collections.unmodifiableList(new ArrayList());
        }
        return Collections.unmodifiableList(((AuthorizationRuleInner)((Object)this.innerModel())).rights());
    }

    public RuleImpl withListenAccess() {
        if (((AuthorizationRuleInner)((Object)this.innerModel())).rights() == null) {
            ((AuthorizationRuleInner)((Object)this.innerModel())).withRights(new ArrayList<AccessRights>());
        }
        if (!((AuthorizationRuleInner)((Object)this.innerModel())).rights().contains((Object)AccessRights.LISTEN)) {
            ((AuthorizationRuleInner)((Object)this.innerModel())).rights().add(AccessRights.LISTEN);
        }
        return (RuleImpl)this;
    }

    public RuleImpl withSendAccess() {
        if (((AuthorizationRuleInner)((Object)this.innerModel())).rights() == null) {
            ((AuthorizationRuleInner)((Object)this.innerModel())).withRights(new ArrayList<AccessRights>());
        }
        if (!((AuthorizationRuleInner)((Object)this.innerModel())).rights().contains((Object)AccessRights.SEND)) {
            ((AuthorizationRuleInner)((Object)this.innerModel())).rights().add(AccessRights.SEND);
        }
        return (RuleImpl)this;
    }

    public RuleImpl withSendAndListenAccess() {
        this.withListenAccess();
        this.withSendAccess();
        return (RuleImpl)this;
    }

    public RuleImpl withManageAccess() {
        this.withListenAccess();
        this.withSendAccess();
        if (!((AuthorizationRuleInner)((Object)this.innerModel())).rights().contains((Object)AccessRights.MANAGE)) {
            ((AuthorizationRuleInner)((Object)this.innerModel())).rights().add(AccessRights.MANAGE);
        }
        return (RuleImpl)this;
    }

    protected abstract Mono<AccessKeysInner> getKeysInnerAsync();

    protected abstract Mono<AccessKeysInner> regenerateKeysInnerAsync(KeyType var1);

    protected abstract Mono<AuthorizationRuleInner> getInnerAsync();

    public abstract Mono<RuleT> createResourceAsync();
}

