/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.casdoor.util.http;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class HttpClient {
    private static final OkHttpClient okHttpClient = new OkHttpClient();

    public static String syncGet(String url) throws IOException {
        Request request = new Request.Builder().url(url).build();
        Response casdoorResponse = okHttpClient.newCall(request).execute();
        if (casdoorResponse.isSuccessful()) {
            return casdoorResponse.body().string();
        }
        return null;
    }

    public static String postString(String url, String objStr) throws IOException {
        MediaType MEDIA_TYPE = MediaType.parse((String)"text/plain;charset=UTF-8");
        Request request = new Request.Builder().url(url).post(RequestBody.create((MediaType)MEDIA_TYPE, (String)objStr)).build();
        Response response = okHttpClient.newCall(request).execute();
        if (response.isSuccessful()) {
            return response.body().string();
        }
        return null;
    }

    public static String postFile(String url, File file) throws IOException {
        MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", file.getName(), RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (File)file)).build();
        Request request = new Request.Builder().url(url).post((RequestBody)requestBody).build();
        Response response = okHttpClient.newCall(request).execute();
        if (!response.isSuccessful()) {
            throw new IOException("Unexpected code " + response);
        }
        return response.body().string();
    }

    public static String postForm(String url, Map<String, String> fromData) throws IOException {
        FormBody.Builder formBodyBuilder = new FormBody.Builder();
        fromData.forEach((arg_0, arg_1) -> ((FormBody.Builder)formBodyBuilder).addEncoded(arg_0, arg_1));
        FormBody formBody = formBodyBuilder.build();
        Request request = new Request.Builder().url(url).post((RequestBody)formBody).build();
        try (Response response = okHttpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected code " + response);
            }
            String string = Objects.requireNonNull(response.body()).string();
            return string;
        }
    }
}

