/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.storage.s3;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.ListObjectsV2Request;
import com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.authentication.aws.AmazonS3ClientFactory;
import org.apache.dolphinscheduler.common.utils.FileUtils;
import org.apache.dolphinscheduler.plugin.storage.api.AbstractStorageOperator;
import org.apache.dolphinscheduler.plugin.storage.api.ResourceMetadata;
import org.apache.dolphinscheduler.plugin.storage.api.StorageEntity;
import org.apache.dolphinscheduler.plugin.storage.api.StorageOperator;
import org.apache.dolphinscheduler.plugin.storage.s3.S3StorageProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3StorageOperator
extends AbstractStorageOperator
implements Closeable,
StorageOperator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(S3StorageOperator.class);
    private final String bucketName;
    private final AmazonS3 s3Client;

    public S3StorageOperator(S3StorageProperties s3StorageProperties) {
        super(s3StorageProperties.getResourceUploadPath());
        this.bucketName = s3StorageProperties.getBucketName();
        this.s3Client = AmazonS3ClientFactory.createAmazonS3Client(s3StorageProperties.getS3Configuration());
        this.exceptionWhenBucketNameNotExists(this.bucketName);
    }

    public String getStorageBaseDirectory() {
        if (this.resourceBaseAbsolutePath.startsWith("/")) {
            log.warn("{} -> {} should not start with / in s3", (Object)"resource.storage.upload.base.path", (Object)this.resourceBaseAbsolutePath);
            return this.resourceBaseAbsolutePath.substring(1);
        }
        return this.resourceBaseAbsolutePath;
    }

    @Override
    public void close() throws IOException {
        this.s3Client.shutdown();
    }

    public void createStorageDir(String directoryAbsolutePath) {
        directoryAbsolutePath = this.transformAbsolutePathToS3Key(directoryAbsolutePath);
        if (this.s3Client.doesObjectExist(this.bucketName, directoryAbsolutePath)) {
            throw new FileAlreadyExistsException("The directory " + directoryAbsolutePath + " already exists in the bucket " + this.bucketName);
        }
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentLength(0L);
        ByteArrayInputStream emptyContent = new ByteArrayInputStream(new byte[0]);
        PutObjectRequest putObjectRequest = new PutObjectRequest(this.bucketName, directoryAbsolutePath, (InputStream)emptyContent, metadata);
        this.s3Client.putObject(putObjectRequest);
    }

    public void download(String srcFilePath, String dstFilePath, boolean overwrite) {
        srcFilePath = this.transformAbsolutePathToS3Key(srcFilePath);
        File dstFile = new File(dstFilePath);
        if (dstFile.isDirectory()) {
            Files.delete(dstFile.toPath());
        } else {
            FileUtils.createDirectoryWithPermission((Path)dstFile.getParentFile().toPath(), (Set)FileUtils.PERMISSION_755);
        }
        S3Object o = this.s3Client.getObject(this.bucketName, srcFilePath);
        try (S3ObjectInputStream s3is = o.getObjectContent();
             FileOutputStream fos = new FileOutputStream(dstFilePath);){
            int readLen;
            byte[] readBuf = new byte[1024];
            while ((readLen = s3is.read(readBuf)) > 0) {
                fos.write(readBuf, 0, readLen);
            }
        }
    }

    public boolean exists(String fullName) {
        fullName = this.transformAbsolutePathToS3Key(fullName);
        return this.s3Client.doesObjectExist(this.bucketName, fullName);
    }

    public void delete(String absolutePath, boolean recursive) {
        ResourceMetadata resourceMetaData = this.getResourceMetaData(absolutePath = this.transformAbsolutePathToS3Key(absolutePath));
        if (!resourceMetaData.isDirectory()) {
            this.s3Client.deleteObject(this.bucketName, absolutePath);
            return;
        }
        if (recursive) {
            List<StorageEntity> storageEntities = this.listStorageEntityRecursively(absolutePath);
            for (StorageEntity storageEntity : storageEntities) {
                this.s3Client.deleteObject(this.bucketName, this.transformAbsolutePathToS3Key(storageEntity.getFullName()));
            }
        }
        this.s3Client.deleteObject(this.bucketName, absolutePath);
    }

    public void copy(String srcPath, String dstPath, boolean deleteSource, boolean overwrite) {
        srcPath = this.transformAbsolutePathToS3Key(srcPath);
        dstPath = this.transformAbsolutePathToS3Key(dstPath);
        ResourceMetadata resourceMetaData = this.getResourceMetaData(srcPath);
        if (resourceMetaData.isDirectory()) {
            throw new UnsupportedOperationException("S3 does not support copying directories.");
        }
        this.s3Client.copyObject(this.bucketName, srcPath, this.bucketName, dstPath);
        if (deleteSource) {
            this.s3Client.deleteObject(this.bucketName, srcPath);
        }
    }

    public void upload(String srcFile, String dstPath, boolean deleteSource, boolean overwrite) {
        dstPath = this.transformAbsolutePathToS3Key(dstPath);
        if (this.s3Client.doesObjectExist(this.bucketName, dstPath)) {
            if (overwrite) {
                this.s3Client.deleteObject(this.bucketName, dstPath);
            } else {
                throw new FileAlreadyExistsException("The file " + dstPath + " already exists in the bucket " + this.bucketName + " and overwrite is not allowed.");
            }
        }
        this.s3Client.putObject(this.bucketName, dstPath, new File(srcFile));
        if (deleteSource) {
            Files.delete(Paths.get(srcFile, new String[0]));
        }
    }

    /*
     * Exception decompiling
     */
    public List<String> fetchFileContent(String filePath, int skipLineNums, int limit) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void exceptionWhenBucketNameNotExists(String bucketName) {
        if (StringUtils.isBlank((CharSequence)bucketName)) {
            throw new IllegalArgumentException("resource.aws.s3.bucket.name is blank");
        }
        boolean existsBucket = this.s3Client.doesBucketExistV2(bucketName);
        if (!existsBucket) {
            throw new IllegalArgumentException("bucketName: " + bucketName + " is not exists, you need to create them by yourself");
        }
        log.info("bucketName: {} has been found, the current regionName is {}", (Object)bucketName, (Object)this.s3Client.getRegionName());
    }

    public List<StorageEntity> listStorageEntity(String resourceAbsolutePath) {
        String s3ResourceAbsolutePath = this.transformAbsolutePathToS3Key(resourceAbsolutePath);
        ListObjectsV2Request listObjectsV2Request = new ListObjectsV2Request().withBucketName(this.bucketName).withDelimiter("/").withPrefix(s3ResourceAbsolutePath);
        ListObjectsV2Result listObjectsV2Result = this.s3Client.listObjectsV2(listObjectsV2Request);
        ArrayList<StorageEntity> storageEntities = new ArrayList<StorageEntity>();
        storageEntities.addAll(listObjectsV2Result.getCommonPrefixes().stream().map(this::transformCommonPrefixToStorageEntity).collect(Collectors.toList()));
        storageEntities.addAll(listObjectsV2Result.getObjectSummaries().stream().filter(s3ObjectSummary -> !s3ObjectSummary.getKey().equals(s3ResourceAbsolutePath)).map(this::transformS3ObjectToStorageEntity).collect(Collectors.toList()));
        return storageEntities;
    }

    public List<StorageEntity> listFileStorageEntityRecursively(String resourceAbsolutePath) {
        return this.listStorageEntityRecursively(resourceAbsolutePath).stream().filter(storageEntity -> !storageEntity.isDirectory()).collect(Collectors.toList());
    }

    public StorageEntity getStorageEntity(String resourceAbsolutePath) {
        resourceAbsolutePath = this.transformAbsolutePathToS3Key(resourceAbsolutePath);
        S3Object object = this.s3Client.getObject(this.bucketName, resourceAbsolutePath);
        return this.transformS3ObjectToStorageEntity(object);
    }

    private List<StorageEntity> listStorageEntityRecursively(String resourceAbsolutePath) {
        resourceAbsolutePath = this.transformAbsolutePathToS3Key(resourceAbsolutePath);
        HashSet<String> visited = new HashSet<String>();
        ArrayList<StorageEntity> storageEntityList = new ArrayList<StorageEntity>();
        LinkedList<String> foldersToFetch = new LinkedList<String>();
        foldersToFetch.addLast(resourceAbsolutePath);
        while (!foldersToFetch.isEmpty()) {
            String pathToExplore = (String)foldersToFetch.pop();
            visited.add(pathToExplore);
            List<StorageEntity> tempList = this.listStorageEntity(pathToExplore);
            for (StorageEntity temp : tempList) {
                if (!temp.isDirectory() || visited.contains(temp.getFullName())) continue;
                foldersToFetch.add(temp.getFullName());
            }
            storageEntityList.addAll(tempList);
        }
        return storageEntityList;
    }

    private StorageEntity transformS3ObjectToStorageEntity(S3Object object) {
        String s3Key = object.getKey();
        String absolutePath = this.transformS3KeyToAbsolutePath(s3Key);
        ResourceMetadata resourceMetaData = this.getResourceMetaData(absolutePath);
        StorageEntity entity = new StorageEntity();
        entity.setFileName(new File(absolutePath).getName());
        entity.setFullName(absolutePath);
        entity.setDirectory(resourceMetaData.isDirectory());
        entity.setType(resourceMetaData.getResourceType());
        entity.setSize(object.getObjectMetadata().getContentLength());
        entity.setRelativePath(resourceMetaData.getResourceRelativePath());
        entity.setCreateTime(object.getObjectMetadata().getLastModified());
        entity.setUpdateTime(object.getObjectMetadata().getLastModified());
        return entity;
    }

    private StorageEntity transformCommonPrefixToStorageEntity(String commonPrefix) {
        String absolutePath = this.transformS3KeyToAbsolutePath(commonPrefix);
        ResourceMetadata resourceMetaData = this.getResourceMetaData(absolutePath);
        StorageEntity entity = new StorageEntity();
        entity.setFileName(new File(absolutePath).getName());
        entity.setFullName(absolutePath);
        entity.setDirectory(resourceMetaData.isDirectory());
        entity.setType(resourceMetaData.getResourceType());
        entity.setSize(0L);
        entity.setCreateTime(null);
        entity.setUpdateTime(null);
        return entity;
    }

    private StorageEntity transformS3ObjectToStorageEntity(S3ObjectSummary s3ObjectSummary) {
        String absolutePath = this.transformS3KeyToAbsolutePath(s3ObjectSummary.getKey());
        ResourceMetadata resourceMetaData = this.getResourceMetaData(absolutePath);
        StorageEntity entity = new StorageEntity();
        entity.setFileName(new File(absolutePath).getName());
        entity.setFullName(absolutePath);
        entity.setPfullName(resourceMetaData.getResourceParentAbsolutePath());
        entity.setDirectory(resourceMetaData.isDirectory());
        entity.setType(resourceMetaData.getResourceType());
        entity.setSize(s3ObjectSummary.getSize());
        entity.setCreateTime(s3ObjectSummary.getLastModified());
        entity.setUpdateTime(s3ObjectSummary.getLastModified());
        return entity;
    }

    private String transformAbsolutePathToS3Key(String absolutePath) {
        ResourceMetadata resourceMetaData = this.getResourceMetaData(absolutePath);
        if (resourceMetaData.isDirectory()) {
            return FileUtils.concatFilePath((String[])new String[]{absolutePath, "/"});
        }
        return absolutePath;
    }

    private String transformS3KeyToAbsolutePath(String s3Key) {
        if (s3Key.endsWith("/")) {
            return s3Key.substring(0, s3Key.length() - 1);
        }
        return s3Key;
    }
}

