/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.cdn.fluent.AfdCustomDomainsClient;
import com.azure.resourcemanager.cdn.fluent.AfdEndpointsClient;
import com.azure.resourcemanager.cdn.fluent.AfdOriginGroupsClient;
import com.azure.resourcemanager.cdn.fluent.AfdOriginsClient;
import com.azure.resourcemanager.cdn.fluent.AfdProfilesClient;
import com.azure.resourcemanager.cdn.fluent.CdnManagementClient;
import com.azure.resourcemanager.cdn.fluent.CustomDomainsClient;
import com.azure.resourcemanager.cdn.fluent.EdgeNodesClient;
import com.azure.resourcemanager.cdn.fluent.EndpointsClient;
import com.azure.resourcemanager.cdn.fluent.LogAnalyticsClient;
import com.azure.resourcemanager.cdn.fluent.ManagedRuleSetsClient;
import com.azure.resourcemanager.cdn.fluent.OperationsClient;
import com.azure.resourcemanager.cdn.fluent.OriginGroupsClient;
import com.azure.resourcemanager.cdn.fluent.OriginsClient;
import com.azure.resourcemanager.cdn.fluent.PoliciesClient;
import com.azure.resourcemanager.cdn.fluent.ProfilesClient;
import com.azure.resourcemanager.cdn.fluent.ResourceUsagesClient;
import com.azure.resourcemanager.cdn.fluent.RoutesClient;
import com.azure.resourcemanager.cdn.fluent.RuleSetsClient;
import com.azure.resourcemanager.cdn.fluent.RulesClient;
import com.azure.resourcemanager.cdn.fluent.SecretsClient;
import com.azure.resourcemanager.cdn.fluent.SecurityPoliciesClient;
import com.azure.resourcemanager.cdn.fluent.ValidatesClient;
import com.azure.resourcemanager.cdn.fluent.models.CheckEndpointNameAvailabilityOutputInner;
import com.azure.resourcemanager.cdn.fluent.models.CheckNameAvailabilityOutputInner;
import com.azure.resourcemanager.cdn.fluent.models.ValidateProbeOutputInner;
import com.azure.resourcemanager.cdn.implementation.AfdCustomDomainsClientImpl;
import com.azure.resourcemanager.cdn.implementation.AfdEndpointsClientImpl;
import com.azure.resourcemanager.cdn.implementation.AfdOriginGroupsClientImpl;
import com.azure.resourcemanager.cdn.implementation.AfdOriginsClientImpl;
import com.azure.resourcemanager.cdn.implementation.AfdProfilesClientImpl;
import com.azure.resourcemanager.cdn.implementation.CdnManagementClientBuilder;
import com.azure.resourcemanager.cdn.implementation.CustomDomainsClientImpl;
import com.azure.resourcemanager.cdn.implementation.EdgeNodesClientImpl;
import com.azure.resourcemanager.cdn.implementation.EndpointsClientImpl;
import com.azure.resourcemanager.cdn.implementation.LogAnalyticsClientImpl;
import com.azure.resourcemanager.cdn.implementation.ManagedRuleSetsClientImpl;
import com.azure.resourcemanager.cdn.implementation.OperationsClientImpl;
import com.azure.resourcemanager.cdn.implementation.OriginGroupsClientImpl;
import com.azure.resourcemanager.cdn.implementation.OriginsClientImpl;
import com.azure.resourcemanager.cdn.implementation.PoliciesClientImpl;
import com.azure.resourcemanager.cdn.implementation.ProfilesClientImpl;
import com.azure.resourcemanager.cdn.implementation.ResourceUsagesClientImpl;
import com.azure.resourcemanager.cdn.implementation.RoutesClientImpl;
import com.azure.resourcemanager.cdn.implementation.RuleSetsClientImpl;
import com.azure.resourcemanager.cdn.implementation.RulesClientImpl;
import com.azure.resourcemanager.cdn.implementation.SecretsClientImpl;
import com.azure.resourcemanager.cdn.implementation.SecurityPoliciesClientImpl;
import com.azure.resourcemanager.cdn.implementation.ValidatesClientImpl;
import com.azure.resourcemanager.cdn.models.CheckEndpointNameAvailabilityInput;
import com.azure.resourcemanager.cdn.models.CheckNameAvailabilityInput;
import com.azure.resourcemanager.cdn.models.ValidateProbeInput;
import com.azure.resourcemanager.resources.fluentcore.AzureServiceClient;
import java.time.Duration;
import reactor.core.publisher.Mono;

@ServiceClient(builder=CdnManagementClientBuilder.class)
public final class CdnManagementClientImpl
extends AzureServiceClient
implements CdnManagementClient {
    private final CdnManagementClientService service;
    private final String subscriptionId;
    private final String endpoint;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final Duration defaultPollInterval;
    private final AfdProfilesClient afdProfiles;
    private final AfdCustomDomainsClient afdCustomDomains;
    private final AfdEndpointsClient afdEndpoints;
    private final AfdOriginGroupsClient afdOriginGroups;
    private final AfdOriginsClient afdOrigins;
    private final RoutesClient routes;
    private final RuleSetsClient ruleSets;
    private final RulesClient rules;
    private final SecurityPoliciesClient securityPolicies;
    private final SecretsClient secrets;
    private final ValidatesClient validates;
    private final LogAnalyticsClient logAnalytics;
    private final ProfilesClient profiles;
    private final EndpointsClient endpoints;
    private final OriginsClient origins;
    private final OriginGroupsClient originGroups;
    private final CustomDomainsClient customDomains;
    private final ResourceUsagesClient resourceUsages;
    private final OperationsClient operations;
    private final EdgeNodesClient edgeNodes;
    private final PoliciesClient policies;
    private final ManagedRuleSetsClient managedRuleSets;

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    @Override
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    @Override
    public AfdProfilesClient getAfdProfiles() {
        return this.afdProfiles;
    }

    @Override
    public AfdCustomDomainsClient getAfdCustomDomains() {
        return this.afdCustomDomains;
    }

    @Override
    public AfdEndpointsClient getAfdEndpoints() {
        return this.afdEndpoints;
    }

    @Override
    public AfdOriginGroupsClient getAfdOriginGroups() {
        return this.afdOriginGroups;
    }

    @Override
    public AfdOriginsClient getAfdOrigins() {
        return this.afdOrigins;
    }

    @Override
    public RoutesClient getRoutes() {
        return this.routes;
    }

    @Override
    public RuleSetsClient getRuleSets() {
        return this.ruleSets;
    }

    @Override
    public RulesClient getRules() {
        return this.rules;
    }

    @Override
    public SecurityPoliciesClient getSecurityPolicies() {
        return this.securityPolicies;
    }

    @Override
    public SecretsClient getSecrets() {
        return this.secrets;
    }

    @Override
    public ValidatesClient getValidates() {
        return this.validates;
    }

    @Override
    public LogAnalyticsClient getLogAnalytics() {
        return this.logAnalytics;
    }

    @Override
    public ProfilesClient getProfiles() {
        return this.profiles;
    }

    @Override
    public EndpointsClient getEndpoints() {
        return this.endpoints;
    }

    @Override
    public OriginsClient getOrigins() {
        return this.origins;
    }

    @Override
    public OriginGroupsClient getOriginGroups() {
        return this.originGroups;
    }

    @Override
    public CustomDomainsClient getCustomDomains() {
        return this.customDomains;
    }

    @Override
    public ResourceUsagesClient getResourceUsages() {
        return this.resourceUsages;
    }

    @Override
    public OperationsClient getOperations() {
        return this.operations;
    }

    @Override
    public EdgeNodesClient getEdgeNodes() {
        return this.edgeNodes;
    }

    @Override
    public PoliciesClient getPolicies() {
        return this.policies;
    }

    @Override
    public ManagedRuleSetsClient getManagedRuleSets() {
        return this.managedRuleSets;
    }

    CdnManagementClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, Duration defaultPollInterval, AzureEnvironment environment, String subscriptionId, String endpoint) {
        super(httpPipeline, serializerAdapter, environment);
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.subscriptionId = subscriptionId;
        this.endpoint = endpoint;
        this.apiVersion = "2021-06-01";
        this.afdProfiles = new AfdProfilesClientImpl(this);
        this.afdCustomDomains = new AfdCustomDomainsClientImpl(this);
        this.afdEndpoints = new AfdEndpointsClientImpl(this);
        this.afdOriginGroups = new AfdOriginGroupsClientImpl(this);
        this.afdOrigins = new AfdOriginsClientImpl(this);
        this.routes = new RoutesClientImpl(this);
        this.ruleSets = new RuleSetsClientImpl(this);
        this.rules = new RulesClientImpl(this);
        this.securityPolicies = new SecurityPoliciesClientImpl(this);
        this.secrets = new SecretsClientImpl(this);
        this.validates = new ValidatesClientImpl(this);
        this.logAnalytics = new LogAnalyticsClientImpl(this);
        this.profiles = new ProfilesClientImpl(this);
        this.endpoints = new EndpointsClientImpl(this);
        this.origins = new OriginsClientImpl(this);
        this.originGroups = new OriginGroupsClientImpl(this);
        this.customDomains = new CustomDomainsClientImpl(this);
        this.resourceUsages = new ResourceUsagesClientImpl(this);
        this.operations = new OperationsClientImpl(this);
        this.edgeNodes = new EdgeNodesClientImpl(this);
        this.policies = new PoliciesClientImpl(this);
        this.managedRuleSets = new ManagedRuleSetsClientImpl(this);
        this.service = (CdnManagementClientService)RestProxy.create(CdnManagementClientService.class, (HttpPipeline)this.httpPipeline, (SerializerAdapter)this.getSerializerAdapter());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CheckEndpointNameAvailabilityOutputInner>> checkEndpointNameAvailabilityWithResponseAsync(String resourceGroupName, CheckEndpointNameAvailabilityInput checkEndpointNameAvailabilityInput) {
        if (this.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.getEndpoint() is required and cannot be null."));
        }
        if (this.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (checkEndpointNameAvailabilityInput == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter checkEndpointNameAvailabilityInput is required and cannot be null."));
        }
        checkEndpointNameAvailabilityInput.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.checkEndpointNameAvailability(this.getEndpoint(), this.getSubscriptionId(), resourceGroupName, this.getApiVersion(), checkEndpointNameAvailabilityInput, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CheckEndpointNameAvailabilityOutputInner>> checkEndpointNameAvailabilityWithResponseAsync(String resourceGroupName, CheckEndpointNameAvailabilityInput checkEndpointNameAvailabilityInput, Context context) {
        if (this.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.getEndpoint() is required and cannot be null."));
        }
        if (this.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (checkEndpointNameAvailabilityInput == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter checkEndpointNameAvailabilityInput is required and cannot be null."));
        }
        checkEndpointNameAvailabilityInput.validate();
        String accept = "application/json";
        context = this.mergeContext(context);
        return this.service.checkEndpointNameAvailability(this.getEndpoint(), this.getSubscriptionId(), resourceGroupName, this.getApiVersion(), checkEndpointNameAvailabilityInput, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CheckEndpointNameAvailabilityOutputInner> checkEndpointNameAvailabilityAsync(String resourceGroupName, CheckEndpointNameAvailabilityInput checkEndpointNameAvailabilityInput) {
        return this.checkEndpointNameAvailabilityWithResponseAsync(resourceGroupName, checkEndpointNameAvailabilityInput).flatMap(res -> Mono.justOrEmpty((Object)((CheckEndpointNameAvailabilityOutputInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CheckEndpointNameAvailabilityOutputInner checkEndpointNameAvailability(String resourceGroupName, CheckEndpointNameAvailabilityInput checkEndpointNameAvailabilityInput) {
        return (CheckEndpointNameAvailabilityOutputInner)this.checkEndpointNameAvailabilityAsync(resourceGroupName, checkEndpointNameAvailabilityInput).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CheckEndpointNameAvailabilityOutputInner> checkEndpointNameAvailabilityWithResponse(String resourceGroupName, CheckEndpointNameAvailabilityInput checkEndpointNameAvailabilityInput, Context context) {
        return (Response)this.checkEndpointNameAvailabilityWithResponseAsync(resourceGroupName, checkEndpointNameAvailabilityInput, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CheckNameAvailabilityOutputInner>> checkNameAvailabilityWithResponseAsync(CheckNameAvailabilityInput checkNameAvailabilityInput) {
        if (this.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.getEndpoint() is required and cannot be null."));
        }
        if (checkNameAvailabilityInput == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter checkNameAvailabilityInput is required and cannot be null."));
        }
        checkNameAvailabilityInput.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.checkNameAvailability(this.getEndpoint(), this.getApiVersion(), checkNameAvailabilityInput, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CheckNameAvailabilityOutputInner>> checkNameAvailabilityWithResponseAsync(CheckNameAvailabilityInput checkNameAvailabilityInput, Context context) {
        if (this.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.getEndpoint() is required and cannot be null."));
        }
        if (checkNameAvailabilityInput == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter checkNameAvailabilityInput is required and cannot be null."));
        }
        checkNameAvailabilityInput.validate();
        String accept = "application/json";
        context = this.mergeContext(context);
        return this.service.checkNameAvailability(this.getEndpoint(), this.getApiVersion(), checkNameAvailabilityInput, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CheckNameAvailabilityOutputInner> checkNameAvailabilityAsync(CheckNameAvailabilityInput checkNameAvailabilityInput) {
        return this.checkNameAvailabilityWithResponseAsync(checkNameAvailabilityInput).flatMap(res -> Mono.justOrEmpty((Object)((CheckNameAvailabilityOutputInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CheckNameAvailabilityOutputInner checkNameAvailability(CheckNameAvailabilityInput checkNameAvailabilityInput) {
        return (CheckNameAvailabilityOutputInner)this.checkNameAvailabilityAsync(checkNameAvailabilityInput).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CheckNameAvailabilityOutputInner> checkNameAvailabilityWithResponse(CheckNameAvailabilityInput checkNameAvailabilityInput, Context context) {
        return (Response)this.checkNameAvailabilityWithResponseAsync(checkNameAvailabilityInput, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CheckNameAvailabilityOutputInner>> checkNameAvailabilityWithSubscriptionWithResponseAsync(CheckNameAvailabilityInput checkNameAvailabilityInput) {
        if (this.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.getEndpoint() is required and cannot be null."));
        }
        if (this.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.getSubscriptionId() is required and cannot be null."));
        }
        if (checkNameAvailabilityInput == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter checkNameAvailabilityInput is required and cannot be null."));
        }
        checkNameAvailabilityInput.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.checkNameAvailabilityWithSubscription(this.getEndpoint(), this.getSubscriptionId(), this.getApiVersion(), checkNameAvailabilityInput, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CheckNameAvailabilityOutputInner>> checkNameAvailabilityWithSubscriptionWithResponseAsync(CheckNameAvailabilityInput checkNameAvailabilityInput, Context context) {
        if (this.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.getEndpoint() is required and cannot be null."));
        }
        if (this.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.getSubscriptionId() is required and cannot be null."));
        }
        if (checkNameAvailabilityInput == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter checkNameAvailabilityInput is required and cannot be null."));
        }
        checkNameAvailabilityInput.validate();
        String accept = "application/json";
        context = this.mergeContext(context);
        return this.service.checkNameAvailabilityWithSubscription(this.getEndpoint(), this.getSubscriptionId(), this.getApiVersion(), checkNameAvailabilityInput, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CheckNameAvailabilityOutputInner> checkNameAvailabilityWithSubscriptionAsync(CheckNameAvailabilityInput checkNameAvailabilityInput) {
        return this.checkNameAvailabilityWithSubscriptionWithResponseAsync(checkNameAvailabilityInput).flatMap(res -> Mono.justOrEmpty((Object)((CheckNameAvailabilityOutputInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CheckNameAvailabilityOutputInner checkNameAvailabilityWithSubscription(CheckNameAvailabilityInput checkNameAvailabilityInput) {
        return (CheckNameAvailabilityOutputInner)this.checkNameAvailabilityWithSubscriptionAsync(checkNameAvailabilityInput).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CheckNameAvailabilityOutputInner> checkNameAvailabilityWithSubscriptionWithResponse(CheckNameAvailabilityInput checkNameAvailabilityInput, Context context) {
        return (Response)this.checkNameAvailabilityWithSubscriptionWithResponseAsync(checkNameAvailabilityInput, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ValidateProbeOutputInner>> validateProbeWithResponseAsync(ValidateProbeInput validateProbeInput) {
        if (this.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.getEndpoint() is required and cannot be null."));
        }
        if (this.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.getSubscriptionId() is required and cannot be null."));
        }
        if (validateProbeInput == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter validateProbeInput is required and cannot be null."));
        }
        validateProbeInput.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.validateProbe(this.getEndpoint(), this.getSubscriptionId(), this.getApiVersion(), validateProbeInput, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ValidateProbeOutputInner>> validateProbeWithResponseAsync(ValidateProbeInput validateProbeInput, Context context) {
        if (this.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.getEndpoint() is required and cannot be null."));
        }
        if (this.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.getSubscriptionId() is required and cannot be null."));
        }
        if (validateProbeInput == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter validateProbeInput is required and cannot be null."));
        }
        validateProbeInput.validate();
        String accept = "application/json";
        context = this.mergeContext(context);
        return this.service.validateProbe(this.getEndpoint(), this.getSubscriptionId(), this.getApiVersion(), validateProbeInput, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ValidateProbeOutputInner> validateProbeAsync(ValidateProbeInput validateProbeInput) {
        return this.validateProbeWithResponseAsync(validateProbeInput).flatMap(res -> Mono.justOrEmpty((Object)((ValidateProbeOutputInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ValidateProbeOutputInner validateProbe(ValidateProbeInput validateProbeInput) {
        return (ValidateProbeOutputInner)this.validateProbeAsync(validateProbeInput).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ValidateProbeOutputInner> validateProbeWithResponse(ValidateProbeInput validateProbeInput, Context context) {
        return (Response)this.validateProbeWithResponseAsync(validateProbeInput, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="CdnManagementClient")
    private static interface CdnManagementClientService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/checkEndpointNameAvailability")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<CheckEndpointNameAvailabilityOutputInner>> checkEndpointNameAvailability(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") CheckEndpointNameAvailabilityInput var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/providers/Microsoft.Cdn/checkNameAvailability")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<CheckNameAvailabilityOutputInner>> checkNameAvailability(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") CheckNameAvailabilityInput var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.Cdn/checkNameAvailability")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<CheckNameAvailabilityOutputInner>> checkNameAvailabilityWithSubscription(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") CheckNameAvailabilityInput var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.Cdn/validateProbe")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ValidateProbeOutputInner>> validateProbe(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") ValidateProbeInput var4, @HeaderParam(value="Accept") String var5, Context var6);
    }
}

