/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jdbc.store.journal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.journal.IOCompletion;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.persistence.Persister;
import org.apache.activemq.artemis.utils.ActiveMQBufferInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JDBCJournalRecord {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final byte ADD_RECORD = 11;
    static final byte UPDATE_RECORD = 12;
    static final byte ADD_RECORD_TX = 13;
    static final byte UPDATE_RECORD_TX = 14;
    static final byte DELETE_RECORD_TX = 15;
    static final byte DELETE_RECORD = 16;
    static final byte PREPARE_RECORD = 17;
    static final byte COMMIT_RECORD = 18;
    static final byte ROLLBACK_RECORD = 19;
    private IOCompletion ioCompletion = null;
    private boolean storeLineUp = true;
    private boolean sync = false;
    private Long id;
    private byte recordType;
    private byte compactCount;
    private long txId;
    private int variableSize;
    protected byte userRecordType;
    private InputStream record;
    private int txDataSize;
    private InputStream txData;
    private int txCheckNoRecords;
    private boolean isUpdate;
    private boolean isTransactional;
    private long seq;

    JDBCJournalRecord(long id, byte recordType, long seq) {
        this.id = id;
        this.recordType = recordType;
        this.isUpdate = recordType == 12 || recordType == 14;
        this.isTransactional = recordType == 14 || recordType == 13 || recordType == 15;
        this.compactCount = 0;
        this.txId = 0L;
        this.variableSize = 0;
        this.userRecordType = (byte)-1;
        this.record = new ByteArrayInputStream(new byte[0]);
        this.txDataSize = 0;
        this.txData = new ByteArrayInputStream(new byte[0]);
        this.txCheckNoRecords = 0;
        this.seq = seq;
    }

    public void complete(boolean success) {
        if (this.ioCompletion != null) {
            if (success) {
                this.ioCompletion.done();
            } else {
                this.ioCompletion.onError(ActiveMQExceptionType.IO_ERROR.getCode(), "JDBC Transaction failed.");
            }
        }
    }

    public void storeLineUp() {
        if (this.storeLineUp && this.ioCompletion != null) {
            this.ioCompletion.storeLineUp();
        }
    }

    void writeRecord(PreparedStatement statement) throws Exception {
        byte[] recordBytes = new byte[this.variableSize];
        byte[] txDataBytes = new byte[this.txDataSize];
        try {
            this.record.read(recordBytes);
            this.txData.read(txDataBytes);
        }
        catch (IOException e) {
            logger.error("Error occurred whilst reading Journal Record", (Throwable)e);
            throw e;
        }
        statement.setLong(1, this.id);
        statement.setByte(2, this.recordType);
        statement.setByte(3, this.compactCount);
        statement.setLong(4, this.txId);
        statement.setByte(5, this.userRecordType);
        statement.setInt(6, this.variableSize);
        statement.setBytes(7, recordBytes);
        statement.setInt(8, this.txDataSize);
        statement.setBytes(9, txDataBytes);
        statement.setInt(10, this.txCheckNoRecords);
        statement.setLong(11, this.seq);
        statement.addBatch();
    }

    void writeDeleteRecord(PreparedStatement deleteStatement) throws SQLException {
        deleteStatement.setLong(1, this.id);
        deleteStatement.addBatch();
    }

    static JDBCJournalRecord readRecord(ResultSet rs) throws SQLException {
        JDBCJournalRecord record = new JDBCJournalRecord(rs.getLong(1), (byte)rs.getShort(2), rs.getLong(11));
        record.setCompactCount((byte)rs.getShort(3));
        record.setTxId(rs.getLong(4));
        record.setUserRecordType((byte)rs.getShort(5));
        record.setVariableSize(rs.getInt(6));
        record.setRecord(rs.getBytes(7));
        record.setTxDataSize(rs.getInt(8));
        record.setTxData(rs.getBytes(9));
        record.setTxCheckNoRecords(rs.getInt(10));
        return record;
    }

    IOCompletion getIoCompletion() {
        return this.ioCompletion;
    }

    void setIoCompletion(IOCompletion ioCompletion) {
        this.ioCompletion = ioCompletion;
    }

    public void setStoreLineUp(boolean storeLineUp) {
        this.storeLineUp = storeLineUp;
    }

    public boolean isSync() {
        return this.sync;
    }

    public void setSync(boolean sync) {
        this.sync = sync;
    }

    public Long getId() {
        return this.id;
    }

    public byte getRecordType() {
        return this.recordType;
    }

    byte getCompactCount() {
        return this.compactCount;
    }

    private void setCompactCount(byte compactCount) {
        this.compactCount = compactCount;
    }

    long getTxId() {
        return this.txId;
    }

    void setTxId(long txId) {
        this.txId = txId;
    }

    private void setVariableSize(int variableSize) {
        this.variableSize = variableSize;
    }

    public byte getUserRecordType() {
        return this.userRecordType;
    }

    public void setUserRecordType(byte userRecordType) {
        this.userRecordType = userRecordType;
    }

    public void setRecord(byte[] record) {
        if (record != null) {
            this.variableSize = record.length;
            this.record = new ByteArrayInputStream(record);
        }
    }

    public void setRecord(InputStream record) {
        this.record = record;
    }

    public void setRecord(Persister persister, Object record) {
        this.variableSize = persister.getEncodeSize(record);
        ActiveMQBuffer encodedBuffer = ActiveMQBuffers.fixedBuffer((int)this.variableSize);
        persister.encode(encodedBuffer, record);
        this.record = new ActiveMQBufferInputStream(encodedBuffer);
    }

    public InputStream getRecord() {
        return this.record;
    }

    int getTxCheckNoRecords() {
        return this.txCheckNoRecords;
    }

    private void setTxCheckNoRecords(int txCheckNoRecords) {
        this.txCheckNoRecords = txCheckNoRecords;
    }

    private void setTxDataSize(int txDataSize) {
        this.txDataSize = txDataSize;
    }

    void setTxData(EncodingSupport txData) {
        this.txDataSize = txData.getEncodeSize();
        ActiveMQBuffer encodedBuffer = ActiveMQBuffers.fixedBuffer((int)this.txDataSize);
        txData.encode(encodedBuffer);
        this.txData = new ActiveMQBufferInputStream(encodedBuffer);
    }

    void setTxData(byte[] txData) {
        if (txData != null) {
            this.txDataSize = txData.length;
            this.txData = new ByteArrayInputStream(txData);
        }
    }

    public boolean isUpdate() {
        return this.isUpdate;
    }

    private byte[] getRecordData() throws IOException {
        byte[] data = new byte[this.variableSize];
        this.record.read(data);
        return data;
    }

    byte[] getTxDataAsByteArray() throws IOException {
        byte[] data = new byte[this.txDataSize];
        this.txData.read(data);
        return data;
    }

    RecordInfo toRecordInfo() throws IOException {
        return new RecordInfo(this.getId().longValue(), this.getUserRecordType(), this.getRecordData(), this.isUpdate(), false, (short)this.getCompactCount());
    }

    public boolean isTransactional() {
        return this.isTransactional;
    }

    long getSeq() {
        return this.seq;
    }

    public String toString() {
        return "JDBCJournalRecord{compactCount=" + this.compactCount + ", id=" + this.id + ", isTransactional=" + this.isTransactional + ", isUpdate=" + this.isUpdate + ", recordType=" + this.recordType + ", seq=" + this.seq + ", storeLineUp=" + this.storeLineUp + ", sync=" + this.sync + ", txCheckNoRecords=" + this.txCheckNoRecords + ", txDataSize=" + this.txDataSize + ", txId=" + this.txId + ", userRecordType=" + this.userRecordType + ", variableSize=" + this.variableSize + "}";
    }
}

