/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.tools.perf.dlog;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.common.net.ServiceURI;
import org.apache.bookkeeper.tools.perf.dlog.PerfReaderBase;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.distributedlog.LogRecordWithDLSN;
import org.apache.distributedlog.LogSegmentMetadata;
import org.apache.distributedlog.api.DistributedLogManager;
import org.apache.distributedlog.api.namespace.Namespace;
import org.apache.distributedlog.exceptions.EndOfLogSegmentException;
import org.apache.distributedlog.logsegment.LogSegmentEntryReader;
import org.apache.distributedlog.namespace.NamespaceDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerfSegmentReader
extends PerfReaderBase {
    private static final Logger log = LoggerFactory.getLogger(PerfSegmentReader.class);

    PerfSegmentReader(ServiceURI serviceURI, PerfReaderBase.Flags flags) {
        super(serviceURI, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute(Namespace namespace) throws Exception {
        ArrayList<DistributedLogManager> managers = new ArrayList<DistributedLogManager>(this.flags.numLogs);
        for (int i = 0; i < this.flags.numLogs; ++i) {
            String logName = String.format(this.flags.logName, i);
            managers.add(namespace.openLog(logName));
        }
        log.info("Successfully open {} logs", (Object)managers.size());
        List segments = managers.stream().flatMap(manager -> {
            try {
                return manager.getLogSegments().stream().map(segment -> Pair.of((Object)manager, (Object)segment));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }).collect(Collectors.toList());
        List splits = segments.stream().flatMap(entry -> this.getNumSplits((DistributedLogManager)entry.getLeft(), (LogSegmentMetadata)entry.getRight()).stream()).collect(Collectors.toList());
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            this.isDone.set(true);
            PerfSegmentReader.printAggregatedStats(this.cumulativeRecorder);
        }));
        ExecutorService executor = Executors.newFixedThreadPool(this.flags.numThreads);
        try {
            int i = 0;
            while (i < this.flags.numThreads) {
                int idx = i++;
                List splitsThisThread = splits.stream().filter(split -> splits.indexOf(split) % this.flags.numThreads == idx).collect(Collectors.toList());
                executor.submit(() -> {
                    try {
                        this.read(splitsThisThread);
                    }
                    catch (Exception e) {
                        log.error("Encountered error at writing records", (Throwable)e);
                    }
                });
            }
            log.info("Started {} write threads", (Object)this.flags.numThreads);
            this.reportStats();
        }
        finally {
            executor.shutdown();
            if (!executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                executor.shutdownNow();
            }
            managers.forEach(manager -> manager.asyncClose());
        }
    }

    void read(List<Split> splits) throws Exception {
        log.info("Read thread started with : splits = {}", splits.stream().map(l -> "(log = " + l.manager.getStreamName() + ", segment = " + l.segment.getLogSegmentSequenceNumber() + " [" + l.startEntryId + ", " + l.endEntryId + "])").collect(Collectors.toList()));
        splits.forEach(entry -> {
            try {
                this.readSegmentSplit((Split)entry);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readSegmentSplit(Split split) throws Exception {
        LogSegmentEntryReader reader = (LogSegmentEntryReader)FutureUtils.result((CompletableFuture)split.manager.getNamespaceDriver().getLogSegmentEntryStore(NamespaceDriver.Role.READER).openReader(split.segment, split.getStartEntryId()));
        reader.start();
        try {
            MutableBoolean isDone = new MutableBoolean(false);
            while (!isDone.booleanValue()) {
                List entries = (List)FutureUtils.result((CompletableFuture)reader.readNext(100));
                entries.forEach(entry -> {
                    try {
                        LogRecordWithDLSN record;
                        while ((record = entry.nextRecord()) != null) {
                            this.recordsRead.increment();
                            this.bytesRead.add(record.getPayloadBuf().readableBytes());
                        }
                    }
                    catch (IOException ioe) {
                        throw new UncheckedIOException(ioe);
                    }
                    finally {
                        entry.release();
                    }
                    if (split.getEndEntryId() >= 0L && entry.getEntryId() >= split.getEndEntryId()) {
                        isDone.setValue(true);
                    }
                });
            }
        }
        catch (EndOfLogSegmentException e) {
            return;
        }
        finally {
            reader.asyncClose();
        }
    }

    List<Split> getNumSplits(DistributedLogManager manager, LogSegmentMetadata segment) {
        if (this.flags.numSplitsPerSegment <= 1) {
            return Lists.newArrayList((Object[])new Split[]{new Split(manager, segment, 0L, -1L)});
        }
        long lastEntryId = segment.getLastEntryId();
        long numEntriesPerSplit = (lastEntryId + 1L) / 2L;
        long nextEntryId = 0L;
        ArrayList<Split> splitsInSegment = new ArrayList<Split>(this.flags.numSplitsPerSegment);
        for (int i = 0; i < this.flags.numSplitsPerSegment; ++i) {
            long startEntryId = nextEntryId;
            long endEntryId = i == this.flags.numSplitsPerSegment - 1 ? lastEntryId : nextEntryId + numEntriesPerSplit - 1L;
            splitsInSegment.add(new Split(manager, segment, startEntryId, endEntryId));
            nextEntryId = endEntryId + 1L;
        }
        return splitsInSegment;
    }

    static class Split {
        final DistributedLogManager manager;
        final LogSegmentMetadata segment;
        final long startEntryId;
        final long endEntryId;

        public Split(DistributedLogManager manager, LogSegmentMetadata segment, long startEntryId, long endEntryId) {
            this.manager = manager;
            this.segment = segment;
            this.startEntryId = startEntryId;
            this.endEntryId = endEntryId;
        }

        public DistributedLogManager getManager() {
            return this.manager;
        }

        public LogSegmentMetadata getSegment() {
            return this.segment;
        }

        public long getStartEntryId() {
            return this.startEntryId;
        }

        public long getEndEntryId() {
            return this.endEntryId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Split)) {
                return false;
            }
            Split other = (Split)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getStartEntryId() != other.getStartEntryId()) {
                return false;
            }
            if (this.getEndEntryId() != other.getEndEntryId()) {
                return false;
            }
            DistributedLogManager this$manager = this.getManager();
            DistributedLogManager other$manager = other.getManager();
            if (this$manager == null ? other$manager != null : !this$manager.equals(other$manager)) {
                return false;
            }
            LogSegmentMetadata this$segment = this.getSegment();
            LogSegmentMetadata other$segment = other.getSegment();
            return !(this$segment == null ? other$segment != null : !this$segment.equals(other$segment));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Split;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $startEntryId = this.getStartEntryId();
            result = result * 59 + (int)($startEntryId >>> 32 ^ $startEntryId);
            long $endEntryId = this.getEndEntryId();
            result = result * 59 + (int)($endEntryId >>> 32 ^ $endEntryId);
            DistributedLogManager $manager = this.getManager();
            result = result * 59 + ($manager == null ? 43 : $manager.hashCode());
            LogSegmentMetadata $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            return result;
        }

        public String toString() {
            return "PerfSegmentReader.Split(manager=" + this.getManager() + ", segment=" + this.getSegment() + ", startEntryId=" + this.getStartEntryId() + ", endEntryId=" + this.getEndEntryId() + ")";
        }
    }
}

