# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

# NOTE! THIS FILE IS AUTOMATICALLY GENERATED AND WILL BE OVERWRITTEN!
#
# IF YOU WANT TO MODIFY THIS FILE, YOU SHOULD MODIFY THE TEMPLATE
# `get_provider_info_TEMPLATE.py.jinja2` IN the `dev/breeze/src/airflow_breeze/templates` DIRECTORY


def get_provider_info():
    return {
        "package-name": "apache-airflow-providers-trino",
        "name": "Trino",
        "description": "`Trino <https://trino.io/>`__\n",
        "integrations": [
            {
                "integration-name": "Trino",
                "external-doc-url": "https://trino.io/docs/",
                "logo": "/docs/integration-logos/trino-og.png",
                "how-to-guide": ["/docs/apache-airflow-providers-trino/operators.rst"],
                "tags": ["software"],
            }
        ],
        "asset-uris": [
            {"schemes": ["trino"], "handler": "airflow.providers.trino.assets.trino.sanitize_uri"}
        ],
        "dataset-uris": [
            {"schemes": ["trino"], "handler": "airflow.providers.trino.assets.trino.sanitize_uri"}
        ],
        "hooks": [{"integration-name": "Trino", "python-modules": ["airflow.providers.trino.hooks.trino"]}],
        "transfers": [
            {
                "source-integration-name": "Google Cloud Storage (GCS)",
                "target-integration-name": "Trino",
                "how-to-guide": "/docs/apache-airflow-providers-trino/transfer/gcs_to_trino.rst",
                "python-module": "airflow.providers.trino.transfers.gcs_to_trino",
            }
        ],
        "connection-types": [
            {
                "hook-class-name": "airflow.providers.trino.hooks.trino.TrinoHook",
                "connection-type": "trino",
                "ui-field-behaviour": {
                    "placeholders": {
                        "extra": '{\n "auth": "authentication type",\n "impersonate_as_owner": "allow impersonate as owner",\n "jwt__token": "JWT token",\n "jwt__file": "JWT file path",\n "certs__client_cert_path": "Client certificate path",\n "certs__client_key_path": "Client key path",\n "kerberos__config": "Kerberos config",\n "kerberos__service_name": "Kerberos service name",\n "kerberos__mutual_authentication": "Kerberos mutual authentication",\n "kerberos__force_preemptive": "Kerberos force preemptive",\n "kerberos__hostname_override": "Kerberos hostname override",\n "kerberos__sanitize_mutual_error_response": "Kerberos sanitize mutual error response",\n "kerberos__principal": "Kerberos principal",\n "kerberos__delegate": "Kerberos delegate",\n "kerberos__ca_bundle": "Kerberos CA bundle",\n "session_properties": "session properties",\n "client_tags": "Trino client tags. Example [\'sales\',\'cluster1\']",\n "timezone": "Trino timezone"\n}\n',
                        "login": "Effective user for connection",
                    }
                },
            }
        ],
    }
