/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.serializer.json.simplifier;

import java.io.File;
import java.io.IOException;
import org.jolokia.service.serializer.json.simplifier.AttributeExtractor;
import org.jolokia.service.serializer.json.simplifier.SimplifierAccessor;

public class FileSimplifier
extends SimplifierAccessor<File> {
    public FileSimplifier() {
        super(File.class);
        this.addExtractor("name", new NameAttributeExtractor());
        this.addExtractor("length", new LengthAttributeExtractor());
        this.addExtractor("directory", new IsDirectoryAttributeExtractor());
        this.addExtractor("canonicalPath", new PathAttributeExtractor());
        this.addExtractor("exists", new ExistsAttributeExtractor());
        this.addExtractor("lastModified", new LastModifiedAttributeExtractor());
    }

    @Override
    public String extractString(Object pValue) {
        try {
            return ((File)pValue).getCanonicalPath();
        }
        catch (IOException e) {
            return ((File)pValue).getAbsolutePath();
        }
    }

    private static class NameAttributeExtractor
    implements AttributeExtractor<File> {
        private NameAttributeExtractor() {
        }

        @Override
        public Object extract(File file) {
            return file.getName();
        }
    }

    private static class LengthAttributeExtractor
    implements AttributeExtractor<File> {
        private LengthAttributeExtractor() {
        }

        @Override
        public Object extract(File file) {
            return file.length();
        }
    }

    private static class IsDirectoryAttributeExtractor
    implements AttributeExtractor<File> {
        private IsDirectoryAttributeExtractor() {
        }

        @Override
        public Object extract(File file) {
            return file.isDirectory();
        }
    }

    private static class PathAttributeExtractor
    implements AttributeExtractor<File> {
        private PathAttributeExtractor() {
        }

        @Override
        public Object extract(File file) {
            try {
                return file.getCanonicalPath();
            }
            catch (IOException e) {
                return null;
            }
        }
    }

    private static class ExistsAttributeExtractor
    implements AttributeExtractor<File> {
        private ExistsAttributeExtractor() {
        }

        @Override
        public Object extract(File file) {
            return file.exists();
        }
    }

    private static class LastModifiedAttributeExtractor
    implements AttributeExtractor<File> {
        private LastModifiedAttributeExtractor() {
        }

        @Override
        public Object extract(File value) {
            return value.lastModified();
        }
    }
}

